/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing.type.standard;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.shardingsphere.api.algorithm.sharding.ShardingValue;
import io.shardingsphere.core.hint.HintManagerHolder;
import io.shardingsphere.core.optimizer.condition.ShardingCondition;
import io.shardingsphere.core.optimizer.condition.ShardingConditions;
import io.shardingsphere.core.optimizer.insert.InsertShardingCondition;
import io.shardingsphere.core.routing.strategy.ShardingStrategy;
import io.shardingsphere.core.routing.strategy.hint.HintShardingStrategy;
import io.shardingsphere.core.routing.type.RoutingEngine;
import io.shardingsphere.core.routing.type.RoutingResult;
import io.shardingsphere.core.routing.type.RoutingTable;
import io.shardingsphere.core.routing.type.TableUnit;
import io.shardingsphere.core.rule.BindingTableRule;
import io.shardingsphere.core.rule.DataNode;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.rule.TableRule;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public final class StandardRoutingEngine
implements RoutingEngine {
    private final ShardingRule shardingRule;
    private final String logicTableName;
    private final ShardingConditions shardingConditions;

    @Override
    public RoutingResult route() {
        return this.generateRoutingResult(this.getDataNodes(this.shardingRule.getTableRuleByLogicTableName(this.logicTableName)));
    }

    private RoutingResult generateRoutingResult(Collection<DataNode> routedDataNodes) {
        RoutingResult result = new RoutingResult();
        for (DataNode each : routedDataNodes) {
            TableUnit tableUnit = new TableUnit(each.getDataSourceName());
            tableUnit.getRoutingTables().add(new RoutingTable(this.logicTableName, each.getTableName()));
            result.getTableUnits().getTableUnits().add(tableUnit);
        }
        return result;
    }

    private Collection<DataNode> getDataNodes(TableRule tableRule) {
        if (this.isRoutingByHint(tableRule)) {
            return this.routeByHint(tableRule);
        }
        if (this.isRoutingByShardingConditions(tableRule)) {
            return this.routeByShardingConditions(tableRule);
        }
        return this.routeByMixedConditions(tableRule);
    }

    private boolean isRoutingByHint(TableRule tableRule) {
        return this.shardingRule.getDatabaseShardingStrategy(tableRule) instanceof HintShardingStrategy && this.shardingRule.getTableShardingStrategy(tableRule) instanceof HintShardingStrategy;
    }

    private Collection<DataNode> routeByHint(TableRule tableRule) {
        return this.route(tableRule, this.getDatabaseShardingValuesFromHint(), this.getTableShardingValuesFromHint());
    }

    private boolean isRoutingByShardingConditions(TableRule tableRule) {
        return !(this.shardingRule.getDatabaseShardingStrategy(tableRule) instanceof HintShardingStrategy) && !(this.shardingRule.getTableShardingStrategy(tableRule) instanceof HintShardingStrategy);
    }

    private Collection<DataNode> routeByShardingConditions(TableRule tableRule) {
        return this.shardingConditions.getShardingConditions().isEmpty() ? this.route(tableRule, Collections.emptyList(), Collections.emptyList()) : this.routeByShardingConditionsWithCondition(tableRule);
    }

    private Collection<DataNode> routeByShardingConditionsWithCondition(TableRule tableRule) {
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (ShardingCondition each : this.shardingConditions.getShardingConditions()) {
            Collection<DataNode> dataNodes = this.route(tableRule, this.getShardingValuesFromShardingConditions(this.shardingRule.getDatabaseShardingStrategy(tableRule).getShardingColumns(), each), this.getShardingValuesFromShardingConditions(this.shardingRule.getTableShardingStrategy(tableRule).getShardingColumns(), each));
            this.reviseShardingConditions(each, dataNodes);
            result.addAll(dataNodes);
        }
        return result;
    }

    private Collection<DataNode> routeByMixedConditions(TableRule tableRule) {
        return this.shardingConditions.getShardingConditions().isEmpty() ? this.routeByMixedConditionsWithHint(tableRule) : this.routeByMixedConditionsWithCondition(tableRule);
    }

    private Collection<DataNode> routeByMixedConditionsWithCondition(TableRule tableRule) {
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (ShardingCondition each : this.shardingConditions.getShardingConditions()) {
            Collection<DataNode> dataNodes = this.route(tableRule, this.getDatabaseShardingValues(tableRule, each), this.getTableShardingValues(tableRule, each));
            this.reviseShardingConditions(each, dataNodes);
            result.addAll(dataNodes);
        }
        return result;
    }

    private Collection<DataNode> routeByMixedConditionsWithHint(TableRule tableRule) {
        if (this.shardingRule.getDatabaseShardingStrategy(tableRule) instanceof HintShardingStrategy) {
            return this.route(tableRule, this.getDatabaseShardingValuesFromHint(), Collections.emptyList());
        }
        return this.route(tableRule, Collections.emptyList(), this.getTableShardingValuesFromHint());
    }

    private List<ShardingValue> getDatabaseShardingValues(TableRule tableRule, ShardingCondition shardingCondition) {
        ShardingStrategy dataBaseShardingStrategy = this.shardingRule.getDatabaseShardingStrategy(tableRule);
        return this.isGettingShardingValuesFromHint(dataBaseShardingStrategy) ? this.getDatabaseShardingValuesFromHint() : this.getShardingValuesFromShardingConditions(dataBaseShardingStrategy.getShardingColumns(), shardingCondition);
    }

    private List<ShardingValue> getTableShardingValues(TableRule tableRule, ShardingCondition shardingCondition) {
        ShardingStrategy tableShardingStrategy = this.shardingRule.getTableShardingStrategy(tableRule);
        return this.isGettingShardingValuesFromHint(tableShardingStrategy) ? this.getTableShardingValuesFromHint() : this.getShardingValuesFromShardingConditions(tableShardingStrategy.getShardingColumns(), shardingCondition);
    }

    private boolean isGettingShardingValuesFromHint(ShardingStrategy shardingStrategy) {
        return shardingStrategy instanceof HintShardingStrategy;
    }

    private List<ShardingValue> getDatabaseShardingValuesFromHint() {
        Optional<ShardingValue> shardingValueOptional = HintManagerHolder.getDatabaseShardingValue(this.logicTableName);
        return shardingValueOptional.isPresent() ? Collections.singletonList(shardingValueOptional.get()) : Collections.emptyList();
    }

    private List<ShardingValue> getTableShardingValuesFromHint() {
        Optional<ShardingValue> shardingValueOptional = HintManagerHolder.getTableShardingValue(this.logicTableName);
        return shardingValueOptional.isPresent() ? Collections.singletonList(shardingValueOptional.get()) : Collections.emptyList();
    }

    private List<ShardingValue> getShardingValuesFromShardingConditions(Collection<String> shardingColumns, ShardingCondition shardingCondition) {
        ArrayList<ShardingValue> result = new ArrayList<ShardingValue>(shardingColumns.size());
        for (ShardingValue each : shardingCondition.getShardingValues()) {
            Optional<BindingTableRule> bindingTableRule = this.shardingRule.findBindingTableRule(this.logicTableName);
            if (!this.logicTableName.equals(each.getLogicTableName()) && (!bindingTableRule.isPresent() || !((BindingTableRule)bindingTableRule.get()).hasLogicTable(this.logicTableName)) || !shardingColumns.contains(each.getColumnName())) continue;
            result.add(each);
        }
        return result;
    }

    private Collection<DataNode> route(TableRule tableRule, List<ShardingValue> databaseShardingValues, List<ShardingValue> tableShardingValues) {
        Collection<String> routedDataSources = this.routeDataSources(tableRule, databaseShardingValues);
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (String each : routedDataSources) {
            result.addAll(this.routeTables(tableRule, each, tableShardingValues));
        }
        return result;
    }

    private Collection<String> routeDataSources(TableRule tableRule, List<ShardingValue> databaseShardingValues) {
        Collection<String> availableTargetDatabases = tableRule.getActualDatasourceNames();
        if (databaseShardingValues.isEmpty()) {
            return availableTargetDatabases;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.shardingRule.getDatabaseShardingStrategy(tableRule).doSharding(availableTargetDatabases, databaseShardingValues));
        Preconditions.checkState((!result.isEmpty() ? 1 : 0) != 0, (Object)"no database route info");
        return result;
    }

    private Collection<DataNode> routeTables(TableRule tableRule, String routedDataSource, List<ShardingValue> tableShardingValues) {
        Collection<String> availableTargetTables = tableRule.getActualTableNames(routedDataSource);
        LinkedHashSet<String> routedTables = new LinkedHashSet<String>(tableShardingValues.isEmpty() ? availableTargetTables : this.shardingRule.getTableShardingStrategy(tableRule).doSharding(availableTargetTables, tableShardingValues));
        Preconditions.checkState((!routedTables.isEmpty() ? 1 : 0) != 0, (Object)"no table route info");
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (String each : routedTables) {
            result.add(new DataNode(routedDataSource, each));
        }
        return result;
    }

    private void reviseShardingConditions(ShardingCondition each, Collection<DataNode> dataNodes) {
        if (each instanceof InsertShardingCondition) {
            ((InsertShardingCondition)each).getDataNodes().addAll(dataNodes);
        }
    }

    @ConstructorProperties(value={"shardingRule", "logicTableName", "shardingConditions"})
    public StandardRoutingEngine(ShardingRule shardingRule, String logicTableName, ShardingConditions shardingConditions) {
        this.shardingRule = shardingRule;
        this.logicTableName = logicTableName;
        this.shardingConditions = shardingConditions;
    }
}

