/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing.router.masterslave;

import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.hint.HintManagerHolder;
import io.shardingsphere.core.parsing.SQLJudgeEngine;
import io.shardingsphere.core.routing.router.masterslave.MasterVisitedManager;
import io.shardingsphere.core.rule.MasterSlaveRule;
import io.shardingsphere.core.util.SQLLogger;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public final class MasterSlaveRouter {
    private final MasterSlaveRule masterSlaveRule;
    private final boolean showSQL;

    public Collection<String> route(String sql) {
        Collection<String> result = this.route(new SQLJudgeEngine(sql).judge().getType());
        if (this.showSQL) {
            SQLLogger.logSQL(sql, result);
        }
        return result;
    }

    private Collection<String> route(SQLType sqlType) {
        if (this.isMasterRoute(sqlType)) {
            MasterVisitedManager.setMasterVisited();
            return Collections.singletonList(this.masterSlaveRule.getMasterDataSourceName());
        }
        return Collections.singletonList(this.masterSlaveRule.getLoadBalanceAlgorithm().getDataSource(this.masterSlaveRule.getName(), this.masterSlaveRule.getMasterDataSourceName(), new ArrayList<String>(this.masterSlaveRule.getSlaveDataSourceNames())));
    }

    private boolean isMasterRoute(SQLType sqlType) {
        return SQLType.DQL != sqlType || MasterVisitedManager.isMasterVisited() || HintManagerHolder.isMasterRouteOnly();
    }

    @ConstructorProperties(value={"masterSlaveRule", "showSQL"})
    public MasterSlaveRouter(MasterSlaveRule masterSlaveRule, boolean showSQL) {
        this.masterSlaveRule = masterSlaveRule;
        this.showSQL = showSQL;
    }
}

