/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.token;

import io.shardingsphere.core.parsing.parser.token.SQLToken;
import io.shardingsphere.core.util.SQLUtil;

public final class IndexToken
extends SQLToken {
    private final String originalLiterals;
    private String tableName;

    public IndexToken(int beginPosition, String originalLiterals) {
        super(beginPosition);
        this.originalLiterals = originalLiterals;
    }

    public IndexToken(int beginPosition, String originalLiterals, String tableName) {
        this(beginPosition, originalLiterals);
        this.tableName = tableName;
    }

    public String getIndexName() {
        return SQLUtil.getExactlyValue(this.originalLiterals);
    }

    public String getTableName() {
        return SQLUtil.getExactlyValue(this.tableName);
    }

    public String getOriginalLiterals() {
        return this.originalLiterals;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String toString() {
        return "IndexToken(originalLiterals=" + this.getOriginalLiterals() + ", tableName=" + this.getTableName() + ")";
    }
}

