/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.sql.dal;

import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.parsing.lexer.dialect.mysql.MySQLKeyword;
import io.shardingsphere.core.parsing.lexer.dialect.postgresql.PostgreSQLKeyword;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Keyword;
import io.shardingsphere.core.parsing.lexer.token.TokenType;
import io.shardingsphere.core.parsing.parser.sql.AbstractSQLStatement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class DALStatement
extends AbstractSQLStatement {
    private static final Collection<Keyword> SINGLE_TOKEN_STATEMENT_PREFIX = Arrays.asList(DefaultKeyword.USE, DefaultKeyword.DESC, MySQLKeyword.DESCRIBE, MySQLKeyword.SHOW, PostgreSQLKeyword.SHOW, PostgreSQLKeyword.RESET);
    private static final Collection<Keyword> DUAL_TOKEN_PRIMARY_STATEMENT_PREFIX = Collections.singletonList(DefaultKeyword.SET);
    private static final Collection<Keyword> DUAL_TOKEN_NOT_SECONDARY_STATEMENT_PREFIX = Arrays.asList(DefaultKeyword.ROLE, DefaultKeyword.TRANSACTION, PostgreSQLKeyword.CONSTRAINTS);

    public DALStatement() {
        super(SQLType.DAL);
    }

    public static boolean isDAL(TokenType tokenType) {
        return SINGLE_TOKEN_STATEMENT_PREFIX.contains(tokenType);
    }

    public static boolean isDAL(TokenType primaryTokenType, TokenType secondaryTokenType) {
        return DUAL_TOKEN_PRIMARY_STATEMENT_PREFIX.contains(primaryTokenType) && !DUAL_TOKEN_NOT_SECONDARY_STATEMENT_PREFIX.contains(secondaryTokenType);
    }

    public String toString() {
        return "DALStatement(super=" + super.toString() + ")";
    }
}

