/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.rule.jaxb.loader;

import com.google.common.base.Joiner;
import io.shardingsphere.core.constant.DatabaseType;

public final class RuleDefinitionFileConstant {
    private static final String ROOT_PATH = "META-INF/parsing-rule-definition";
    private static final String COMMON = "common";
    private static final String SQL_STATEMENT_RULE_DEFINITION_FILE_NAME = "sql-statement-rule-definition.xml";
    private static final String EXTRACTOR_RULE_DEFINITION_FILE_NAME = "extractor-rule-definition.xml";
    private static final String FILLER_DEFINITION_FILE_NAME = "filler-rule-definition.xml";

    public static String getSQLStatementRuleDefinitionFileName(DatabaseType databaseType) {
        return Joiner.on((char)'/').join((Object)ROOT_PATH, (Object)databaseType.name().toLowerCase(), new Object[]{SQL_STATEMENT_RULE_DEFINITION_FILE_NAME});
    }

    public static String getExtractorRuleDefinitionFileName(DatabaseType databaseType) {
        return Joiner.on((char)'/').join((Object)ROOT_PATH, (Object)databaseType.name().toLowerCase(), new Object[]{EXTRACTOR_RULE_DEFINITION_FILE_NAME});
    }

    public static String getCommonExtractorRuleDefinitionFileName() {
        return Joiner.on((char)'/').join((Object)ROOT_PATH, (Object)COMMON, new Object[]{EXTRACTOR_RULE_DEFINITION_FILE_NAME});
    }

    public static String getFillerRuleDefinitionFileName() {
        return Joiner.on((char)'/').join((Object)ROOT_PATH, (Object)COMMON, new Object[]{FILLER_DEFINITION_FILE_NAME});
    }

    private RuleDefinitionFileConstant() {
    }
}

