/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.optimizer.impl.dql.dialect.mysql;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.shardingsphere.core.constant.AggregationType;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.parsing.antlr.optimizer.SQLStatementOptimizer;
import io.shardingsphere.core.parsing.parser.constant.DerivedColumn;
import io.shardingsphere.core.parsing.parser.context.condition.OrCondition;
import io.shardingsphere.core.parsing.parser.context.orderby.OrderItem;
import io.shardingsphere.core.parsing.parser.context.selectitem.AggregationDistinctSelectItem;
import io.shardingsphere.core.parsing.parser.context.selectitem.AggregationSelectItem;
import io.shardingsphere.core.parsing.parser.context.selectitem.DistinctSelectItem;
import io.shardingsphere.core.parsing.parser.context.selectitem.SelectItem;
import io.shardingsphere.core.parsing.parser.context.selectitem.StarSelectItem;
import io.shardingsphere.core.parsing.parser.context.table.Table;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.parsing.parser.token.ItemsToken;
import io.shardingsphere.core.parsing.parser.token.OrderByToken;
import java.util.List;

public final class MySQLSelectOptimizer
implements SQLStatementOptimizer {
    @Override
    public void optimize(SQLStatement sqlStatement, ShardingTableMetaData shardingTableMetaData) {
        this.appendDerivedColumns((SelectStatement)sqlStatement, shardingTableMetaData);
        this.appendDerivedOrderBy((SelectStatement)sqlStatement);
        this.postExtractInternal(sqlStatement, shardingTableMetaData);
    }

    private void postExtractInternal(SQLStatement sqlStatement, ShardingTableMetaData shardingTableMetaData) {
        SelectStatement selectStatement = (SelectStatement)sqlStatement;
        for (OrCondition each : selectStatement.getSubQueryConditions()) {
            selectStatement.getConditions().getOrCondition().getAndConditions().addAll(each.getAndConditions());
        }
    }

    private void appendDerivedColumns(SelectStatement selectStatement, ShardingTableMetaData shardingTableMetaData) {
        ItemsToken itemsToken = new ItemsToken(selectStatement.getSelectListLastPosition());
        this.appendAvgDerivedColumns(itemsToken, selectStatement);
        if (!selectStatement.getOrderByItems().isEmpty()) {
            this.appendDerivedOrderColumns(itemsToken, selectStatement.getOrderByItems(), selectStatement, shardingTableMetaData);
        }
        if (!selectStatement.getGroupByItems().isEmpty()) {
            this.appendDerivedGroupColumns(itemsToken, selectStatement.getGroupByItems(), selectStatement, shardingTableMetaData);
        }
        if (!itemsToken.getItems().isEmpty()) {
            selectStatement.addSQLToken(itemsToken);
        }
    }

    private void appendAvgDerivedColumns(ItemsToken itemsToken, SelectStatement selectStatement) {
        int derivedColumnOffset = 0;
        for (SelectItem each : selectStatement.getItems()) {
            if (!this.isAverageSelectItem(each)) continue;
            AggregationSelectItem avgItem = (AggregationSelectItem)each;
            String countAlias = DerivedColumn.AVG_COUNT_ALIAS.getDerivedColumnAlias(derivedColumnOffset);
            AggregationSelectItem countItem = new AggregationSelectItem(AggregationType.COUNT, avgItem.getInnerExpression(), (Optional<String>)Optional.of((Object)countAlias));
            String sumAlias = DerivedColumn.AVG_SUM_ALIAS.getDerivedColumnAlias(derivedColumnOffset);
            AggregationSelectItem sumItem = new AggregationSelectItem(AggregationType.SUM, avgItem.getInnerExpression(), (Optional<String>)Optional.of((Object)sumAlias));
            avgItem.getDerivedAggregationSelectItems().add(countItem);
            avgItem.getDerivedAggregationSelectItems().add(sumItem);
            if (!(avgItem instanceof AggregationDistinctSelectItem)) {
                itemsToken.getItems().add(countItem.getExpression() + " AS " + countAlias + " ");
                itemsToken.getItems().add(sumItem.getExpression() + " AS " + sumAlias + " ");
            }
            ++derivedColumnOffset;
        }
    }

    private boolean isAverageSelectItem(SelectItem each) {
        return each instanceof AggregationSelectItem && AggregationType.AVG == ((AggregationSelectItem)each).getType();
    }

    private void appendDerivedOrderColumns(ItemsToken itemsToken, List<OrderItem> orderItems, SelectStatement selectStatement, ShardingTableMetaData shardingTableMetaData) {
        int derivedColumnOffset = 0;
        for (OrderItem each : orderItems) {
            if (this.containsItem(selectStatement, each, shardingTableMetaData)) continue;
            String alias = DerivedColumn.ORDER_BY_ALIAS.getDerivedColumnAlias(derivedColumnOffset++);
            each.setAlias(alias);
            itemsToken.getItems().add((String)each.getQualifiedName().get() + " AS " + alias + " ");
        }
    }

    private void appendDerivedGroupColumns(ItemsToken itemsToken, List<OrderItem> orderItems, SelectStatement selectStatement, ShardingTableMetaData shardingTableMetaData) {
        int derivedColumnOffset = 0;
        for (OrderItem each : orderItems) {
            if (this.containsItem(selectStatement, each, shardingTableMetaData)) continue;
            String alias = DerivedColumn.GROUP_BY_ALIAS.getDerivedColumnAlias(derivedColumnOffset++);
            each.setAlias(alias);
            itemsToken.getItems().add((String)each.getQualifiedName().get() + " AS " + alias + " ");
        }
    }

    private boolean containsItem(SelectStatement selectStatement, OrderItem orderItem, ShardingTableMetaData shardingTableMetaData) {
        return orderItem.isIndex() || this.containsItemInStarSelectItems(selectStatement, orderItem, shardingTableMetaData) || this.containsItemInSelectItems(selectStatement, orderItem);
    }

    private boolean containsItemInStarSelectItems(SelectStatement selectStatement, OrderItem orderItem, ShardingTableMetaData shardingTableMetaData) {
        return selectStatement.hasUnqualifiedStarSelectItem() || this.containsItemWithOwnerInStarSelectItems(selectStatement, orderItem) || this.containsItemWithoutOwnerInStarSelectItems(selectStatement, orderItem, shardingTableMetaData);
    }

    private boolean containsItemWithOwnerInStarSelectItems(SelectStatement selectStatement, OrderItem orderItem) {
        return orderItem.getOwner().isPresent() && selectStatement.findStarSelectItem((String)orderItem.getOwner().get()).isPresent();
    }

    private boolean containsItemWithoutOwnerInStarSelectItems(SelectStatement selectStatement, OrderItem orderItem, ShardingTableMetaData shardingTableMetaData) {
        if (!orderItem.getOwner().isPresent()) {
            for (StarSelectItem each : selectStatement.getQualifiedStarSelectItems()) {
                if (!this.isSameSelectItem(selectStatement, each, orderItem, shardingTableMetaData)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSameSelectItem(SelectStatement selectStatement, StarSelectItem starSelectItem, OrderItem orderItem, ShardingTableMetaData shardingTableMetaData) {
        Preconditions.checkState((boolean)starSelectItem.getOwner().isPresent());
        Preconditions.checkState((boolean)orderItem.getName().isPresent());
        Optional<Table> table = selectStatement.getTables().find((String)starSelectItem.getOwner().get());
        return table.isPresent() && shardingTableMetaData.containsColumn(((Table)table.get()).getName(), (String)orderItem.getName().get());
    }

    private boolean containsItemInSelectItems(SelectStatement selectStatement, OrderItem orderItem) {
        for (SelectItem each : selectStatement.getItems()) {
            if (!this.containsItemInDistinctItems(orderItem, each) && !this.isSameAlias(each, orderItem) && !this.isSameQualifiedName(each, orderItem)) continue;
            return true;
        }
        return false;
    }

    private boolean containsItemInDistinctItems(OrderItem orderItem, SelectItem selectItem) {
        if (!(selectItem instanceof DistinctSelectItem)) {
            return false;
        }
        DistinctSelectItem distinctSelectItem = (DistinctSelectItem)selectItem;
        return distinctSelectItem.getDistinctColumnLabels().contains(orderItem.getColumnLabel());
    }

    private boolean isSameAlias(SelectItem selectItem, OrderItem orderItem) {
        return selectItem.getAlias().isPresent() && orderItem.getAlias().isPresent() && ((String)selectItem.getAlias().get()).equalsIgnoreCase((String)orderItem.getAlias().get());
    }

    private boolean isSameQualifiedName(SelectItem selectItem, OrderItem orderItem) {
        return !selectItem.getAlias().isPresent() && orderItem.getQualifiedName().isPresent() && selectItem.getExpression().equalsIgnoreCase((String)orderItem.getQualifiedName().get());
    }

    private void appendDerivedOrderBy(SelectStatement selectStatement) {
        if (!selectStatement.getGroupByItems().isEmpty() && selectStatement.getOrderByItems().isEmpty()) {
            selectStatement.getOrderByItems().addAll(selectStatement.getGroupByItems());
            selectStatement.addSQLToken(new OrderByToken(selectStatement.getGroupByLastPosition()));
        }
    }
}

