/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.filler.impl.ddl;

import com.google.common.base.Optional;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.parsing.antlr.filler.SQLStatementFiller;
import io.shardingsphere.core.parsing.antlr.sql.segment.definition.column.ColumnDefinitionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.definition.constraint.ConstraintDefinitionSegment;
import io.shardingsphere.core.parsing.antlr.sql.statement.ddl.AlterTableStatement;
import io.shardingsphere.core.parsing.antlr.sql.statement.ddl.CreateTableStatement;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.rule.ShardingRule;

public final class ConstraintDefinitionFiller
implements SQLStatementFiller<ConstraintDefinitionSegment> {
    @Override
    public void fill(ConstraintDefinitionSegment sqlSegment, SQLStatement sqlStatement, String sql, ShardingRule shardingRule, ShardingTableMetaData shardingTableMetaData) {
        if (sqlStatement instanceof CreateTableStatement) {
            this.fill(sqlSegment, (CreateTableStatement)sqlStatement);
        } else if (sqlStatement instanceof AlterTableStatement) {
            this.fill(sqlSegment, (AlterTableStatement)sqlStatement, shardingTableMetaData);
        }
    }

    private void fill(ConstraintDefinitionSegment sqlSegment, CreateTableStatement createTableStatement) {
        for (ColumnDefinitionSegment each : createTableStatement.getColumnDefinitions()) {
            if (!sqlSegment.getPrimaryKeyColumnNames().contains(each.getColumnName())) continue;
            each.setPrimaryKey(true);
        }
    }

    private void fill(ConstraintDefinitionSegment sqlSegment, AlterTableStatement alterTableStatement, ShardingTableMetaData shardingTableMetaData) {
        for (String each : sqlSegment.getPrimaryKeyColumnNames()) {
            Optional<ColumnDefinitionSegment> modifiedColumn = alterTableStatement.findColumnDefinition(each, shardingTableMetaData);
            if (!modifiedColumn.isPresent()) continue;
            ((ColumnDefinitionSegment)modifiedColumn.get()).setPrimaryKey(true);
            alterTableStatement.getModifiedColumnDefinitions().put(each, (ColumnDefinitionSegment)modifiedColumn.get());
        }
    }
}

