/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.extractor.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.shardingsphere.core.parsing.antlr.extractor.OptionalSQLSegmentExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.impl.ColumnSegmentExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.impl.dql.SubqueryExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.util.ExtractorUtils;
import io.shardingsphere.core.parsing.antlr.extractor.util.RuleName;
import io.shardingsphere.core.parsing.antlr.sql.segment.column.ColumnSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.CommonExpressionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.ExpressionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.ExpressionWithAliasSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.FunctionExpressionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.PropertyExpressionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.StarExpressionSegment;
import io.shardingsphere.core.parsing.lexer.token.Symbol;
import io.shardingsphere.core.util.SQLUtil;
import java.util.HashMap;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public final class ExpressionExtractor
implements OptionalSQLSegmentExtractor {
    private final SubqueryExtractor subqueryExtractor = new SubqueryExtractor();

    public Optional<? extends ExpressionSegment> extract(ParserRuleContext expressionNode) {
        String firstChildText = expressionNode.getText();
        if (firstChildText.endsWith(Symbol.STAR.getLiterals())) {
            return Optional.of((Object)this.getStarExpressionSegment(expressionNode, firstChildText));
        }
        Optional<ParserRuleContext> subqueryNode = ExtractorUtils.findFirstChildNode(expressionNode, RuleName.SUBQUERY);
        return subqueryNode.isPresent() ? this.subqueryExtractor.extract((ParserRuleContext)subqueryNode.get()) : Optional.of((Object)this.getExpressionWithAliasSegment(expressionNode));
    }

    private ExpressionSegment getStarExpressionSegment(ParserRuleContext expressionNode, String text) {
        StarExpressionSegment result = new StarExpressionSegment(expressionNode.getStart().getStartIndex());
        if (text.contains(Symbol.DOT.getLiterals())) {
            result.setOwner(SQLUtil.getExactlyValue(text.substring(0, text.indexOf(Symbol.DOT.getLiterals()))));
        }
        return result;
    }

    private ExpressionWithAliasSegment getExpressionWithAliasSegment(ParserRuleContext expressionNode) {
        Optional<ParserRuleContext> functionNode = ExtractorUtils.findFirstChildNode(expressionNode, RuleName.FUNCTION_CALL);
        ExpressionWithAliasSegment result = functionNode.isPresent() ? this.getFunctionExpressionSegment(expressionNode, (ParserRuleContext)functionNode.get()) : (RuleName.COLUMN_NAME.getName().equals(expressionNode.getChild(0).getClass().getSimpleName()) ? this.getPropertyExpressionSegment(expressionNode) : new CommonExpressionSegment(expressionNode.getStart().getStartIndex(), expressionNode.getStop().getStopIndex()));
        Optional<String> alias = this.getAlias(expressionNode);
        if (alias.isPresent()) {
            result.setAlias((String)alias.get());
        }
        return result;
    }

    private ExpressionWithAliasSegment getFunctionExpressionSegment(ParserRuleContext expressionNode, ParserRuleContext functionNode) {
        String functionName = functionNode.getChild(0).getText();
        int startIndex = ((TerminalNode)functionNode.getChild(1)).getSymbol().getStartIndex();
        int distinctColumnNameStartPosition = ExtractorUtils.findFirstChildNode(expressionNode, RuleName.DISTINCT).isPresent() ? this.calculateDistinctColumnNamePosition(functionNode) : -1;
        return new FunctionExpressionSegment(functionName, functionNode.getStart().getStartIndex(), startIndex, functionNode.getStop().getStopIndex(), distinctColumnNameStartPosition);
    }

    private int calculateDistinctColumnNamePosition(ParserRuleContext functionNode) {
        ParseTree distinctItemNode = functionNode.getChild(3);
        if (distinctItemNode instanceof TerminalNode) {
            return ((TerminalNode)distinctItemNode).getSymbol().getStartIndex();
        }
        if (distinctItemNode instanceof ParserRuleContext) {
            return ((ParserRuleContext)distinctItemNode).getStart().getStartIndex();
        }
        return -1;
    }

    private ExpressionWithAliasSegment getPropertyExpressionSegment(ParserRuleContext expressionNode) {
        ParserRuleContext columnNode = (ParserRuleContext)expressionNode.getChild(0);
        Optional<ColumnSegment> columnSegment = new ColumnSegmentExtractor(new HashMap<String, String>()).extract(columnNode);
        Preconditions.checkState((boolean)columnSegment.isPresent());
        return new PropertyExpressionSegment(((ColumnSegment)columnSegment.get()).getOwner(), ((ColumnSegment)columnSegment.get()).getName(), columnNode.getStart().getStartIndex(), columnNode.getStop().getStopIndex());
    }

    private Optional<String> getAlias(ParserRuleContext expressionNode) {
        Optional<ParserRuleContext> aliasNode = ExtractorUtils.findFirstChildNode(expressionNode, RuleName.ALIAS);
        return aliasNode.isPresent() ? Optional.of((Object)SQLUtil.getExactlyValue(((ParserRuleContext)aliasNode.get()).getText())) : Optional.absent();
    }
}

