/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.merger;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.merger.MergeEngine;
import io.shardingsphere.core.merger.QueryResult;
import io.shardingsphere.core.merger.dal.DALMergeEngine;
import io.shardingsphere.core.merger.dql.DQLMergeEngine;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dal.DALStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.rule.ShardingRule;
import java.sql.SQLException;
import java.util.List;

public final class MergeEngineFactory {
    public static MergeEngine newInstance(DatabaseType databaseType, ShardingRule shardingRule, SQLStatement sqlStatement, ShardingTableMetaData shardingTableMetaData, List<QueryResult> queryResults) throws SQLException {
        if (sqlStatement instanceof SelectStatement) {
            return new DQLMergeEngine(databaseType, (SelectStatement)sqlStatement, queryResults);
        }
        if (sqlStatement instanceof DALStatement) {
            return new DALMergeEngine(shardingRule, queryResults, (DALStatement)sqlStatement, shardingTableMetaData);
        }
        throw new UnsupportedOperationException(String.format("Cannot support type '%s'", new Object[]{sqlStatement.getType()}));
    }

    private MergeEngineFactory() {
    }
}

