/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.executor.sql.execute.result;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import io.shardingsphere.core.constant.AggregationType;
import io.shardingsphere.core.executor.sql.execute.result.AggregationDistinctQueryMetaData;
import io.shardingsphere.core.executor.sql.execute.result.DistinctQueryResult;
import io.shardingsphere.core.executor.sql.execute.row.QueryRow;
import io.shardingsphere.core.merger.QueryResult;
import io.shardingsphere.core.parsing.parser.context.selectitem.AggregationDistinctSelectItem;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public final class AggregationDistinctQueryResult
extends DistinctQueryResult {
    private final AggregationDistinctQueryMetaData metaData;

    private AggregationDistinctQueryResult(Multimap<String, Integer> columnLabelAndIndexMap, Iterator<QueryRow> resultData, AggregationDistinctQueryMetaData distinctQueryMetaData) {
        super(columnLabelAndIndexMap, resultData);
        this.metaData = distinctQueryMetaData;
    }

    public AggregationDistinctQueryResult(Collection<QueryResult> queryResults, List<AggregationDistinctSelectItem> aggregationDistinctSelectItems) {
        super(queryResults, Lists.transform(aggregationDistinctSelectItems, (Function)new Function<AggregationDistinctSelectItem, String>(){

            public String apply(AggregationDistinctSelectItem input) {
                return input.getDistinctColumnLabel();
            }
        }));
        this.metaData = new AggregationDistinctQueryMetaData(aggregationDistinctSelectItems, this.getColumnLabelAndIndexMap());
    }

    @Override
    public List<DistinctQueryResult> divide() {
        return Lists.newArrayList((Iterator)Iterators.transform(this.getResultData(), (Function)new Function<QueryRow, DistinctQueryResult>(){

            public DistinctQueryResult apply(QueryRow input) {
                LinkedHashSet<QueryRow> resultData = new LinkedHashSet<QueryRow>();
                resultData.add(input);
                return new AggregationDistinctQueryResult(AggregationDistinctQueryResult.this.getColumnLabelAndIndexMap(), resultData.iterator(), AggregationDistinctQueryResult.this.metaData);
            }
        }));
    }

    private Object getValue(int columnIndex) {
        if (this.metaData.getAggregationDistinctColumnIndexes().contains(columnIndex)) {
            return AggregationType.COUNT == this.metaData.getAggregationType(columnIndex) ? Integer.valueOf(1) : super.getValue(columnIndex, Object.class);
        }
        if (this.metaData.getDerivedCountColumnIndexes().contains(columnIndex)) {
            return 1;
        }
        if (this.metaData.getDerivedSumColumnIndexes().contains(columnIndex)) {
            return super.getValue(this.metaData.getAggregationDistinctColumnIndex(columnIndex), Object.class);
        }
        return super.getValue(columnIndex, Object.class);
    }

    private Object getValue(String columnLabel) {
        return this.getValue(this.getColumnIndex(columnLabel));
    }

    @Override
    public Object getValue(int columnIndex, Class<?> type) {
        return this.getValue(columnIndex);
    }

    @Override
    public Object getValue(String columnLabel, Class<?> type) {
        return this.getValue(columnLabel);
    }

    @Override
    public Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) {
        return this.getValue(columnIndex);
    }

    @Override
    public Object getCalendarValue(String columnLabel, Class<?> type, Calendar calendar) {
        return this.getValue(columnLabel);
    }

    @Override
    public InputStream getInputStream(int columnIndex, String type) {
        return this.getInputStream(this.getValue(columnIndex));
    }

    @Override
    public InputStream getInputStream(String columnLabel, String type) {
        return this.getInputStream(this.getValue(columnLabel));
    }

    @Override
    public boolean wasNull() {
        return null == this.getCurrentRow();
    }

    @Override
    public int getColumnCount() {
        return this.getColumnLabelAndIndexMap().size();
    }

    @Override
    public String getColumnLabel(int columnIndex) throws SQLException {
        if (this.metaData.getAggregationDistinctColumnIndexes().contains(columnIndex)) {
            return this.metaData.getAggregationDistinctColumnLabel(columnIndex);
        }
        for (Map.Entry entry : this.getColumnLabelAndIndexMap().entries()) {
            if (columnIndex != (Integer)entry.getValue()) continue;
            return (String)entry.getKey();
        }
        throw new SQLException("Column index out of range", "9999");
    }

    @Override
    protected Integer getColumnIndex(String columnLabel) {
        return this.isContainColumnLabel(columnLabel) ? this.metaData.getAggregationDistinctColumnIndex(columnLabel) : super.getColumnIndex(columnLabel).intValue();
    }

    private boolean isContainColumnLabel(String columnLabel) {
        return null != this.metaData && this.metaData.getAggregationDistinctColumnLabels().contains(columnLabel);
    }
}

