/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.executor.sql.execute;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.executor.ShardingExecuteCallback;
import io.shardingsphere.core.executor.ShardingGroupExecuteCallback;
import io.shardingsphere.core.executor.StatementExecuteUnit;
import io.shardingsphere.core.executor.sql.execute.threadlocal.ExecutorExceptionHandler;
import io.shardingsphere.core.metadata.datasource.DataSourceMetaData;
import io.shardingsphere.core.metadata.datasource.DataSourceMetaDataFactory;
import io.shardingsphere.spi.executor.SPISQLExecutionHook;
import java.beans.ConstructorProperties;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;

public abstract class SQLExecuteCallback<T>
implements ShardingExecuteCallback<StatementExecuteUnit, T>,
ShardingGroupExecuteCallback<StatementExecuteUnit, T> {
    private final DatabaseType databaseType;
    private final boolean isExceptionThrown;

    @Override
    public final T execute(StatementExecuteUnit statementExecuteUnit, boolean isTrunkThread, Map<String, Object> shardingExecuteDataMap) throws SQLException {
        return this.execute0(statementExecuteUnit, isTrunkThread, shardingExecuteDataMap);
    }

    @Override
    public final Collection<T> execute(Collection<StatementExecuteUnit> statementExecuteUnits, boolean isTrunkThread, Map<String, Object> shardingExecuteDataMap) throws SQLException {
        LinkedList<T> result = new LinkedList<T>();
        for (StatementExecuteUnit each : statementExecuteUnits) {
            result.add(this.execute0(each, isTrunkThread, shardingExecuteDataMap));
        }
        return result;
    }

    private T execute0(StatementExecuteUnit statementExecuteUnit, boolean isTrunkThread, Map<String, Object> shardingExecuteDataMap) throws SQLException {
        ExecutorExceptionHandler.setExceptionThrown(this.isExceptionThrown);
        DataSourceMetaData dataSourceMetaData = DataSourceMetaDataFactory.newInstance(this.databaseType, statementExecuteUnit.getDatabaseMetaData().getURL());
        SPISQLExecutionHook sqlExecutionHook = new SPISQLExecutionHook();
        try {
            sqlExecutionHook.start(statementExecuteUnit.getRouteUnit(), dataSourceMetaData, isTrunkThread, shardingExecuteDataMap);
            T result = this.executeSQL(statementExecuteUnit);
            sqlExecutionHook.finishSuccess();
            return result;
        }
        catch (SQLException ex) {
            sqlExecutionHook.finishFailure(ex);
            ExecutorExceptionHandler.handleException(ex);
            return null;
        }
    }

    protected abstract T executeSQL(StatementExecuteUnit var1) throws SQLException;

    @ConstructorProperties(value={"databaseType", "isExceptionThrown"})
    public SQLExecuteCallback(DatabaseType databaseType, boolean isExceptionThrown) {
        this.databaseType = databaseType;
        this.isExceptionThrown = isExceptionThrown;
    }
}

