/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.constant;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.Arrays;

public enum DatabaseType {
    H2("H2"),
    MySQL("MySQL"),
    PostgreSQL("PostgreSQL"),
    Oracle("Oracle"),
    SQLServer("Microsoft SQL Server");

    private final String productName;

    private DatabaseType(String productName) {
        this.productName = productName;
    }

    public static DatabaseType valueFrom(final String databaseProductName) {
        Optional databaseTypeOptional = Iterators.tryFind(Arrays.asList(DatabaseType.values()).iterator(), (Predicate)new Predicate<DatabaseType>(){

            public boolean apply(DatabaseType input) {
                return input.productName.equals(databaseProductName);
            }
        });
        if (databaseTypeOptional.isPresent()) {
            return (DatabaseType)((Object)databaseTypeOptional.get());
        }
        throw new UnsupportedOperationException(String.format("Can not support database type [%s].", databaseProductName));
    }
}

