/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.spectator.tcp;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import io.reactivex.netty.protocol.tcp.server.events.TcpServerEventListener;
import io.reactivex.netty.spectator.internal.EventMetric;
import io.reactivex.netty.spectator.internal.SpectatorUtils;
import java.util.concurrent.TimeUnit;

public class TcpServerListener
extends TcpServerEventListener {
    private final Counter connectionAccept;
    private final EventMetric connectionHandling;
    private final EventMetric connectionClose;
    private final EventMetric write;
    private final EventMetric flush;
    private final Counter bytesRead;
    private final Counter bytesWritten;

    public TcpServerListener(Registry registry, String monitorId) {
        this.connectionAccept = SpectatorUtils.newCounter(registry, "connection", monitorId, "rtype", "count", "action", "accept");
        this.connectionHandling = new EventMetric(registry, "connection", monitorId, "action", "handle");
        this.connectionClose = new EventMetric(registry, "connection", monitorId, "action", "close");
        this.write = new EventMetric(registry, "writes", monitorId, "action", "write");
        this.flush = new EventMetric(registry, "writes", monitorId, "action", "flush");
        this.bytesWritten = SpectatorUtils.newCounter(registry, "bytes", monitorId, "rtype", "count", "action", "write");
        this.bytesRead = SpectatorUtils.newCounter(registry, "bytes", monitorId, "rtype", "count", "action", "read");
    }

    public TcpServerListener(String monitorId) {
        this((Registry)Spectator.globalRegistry(), monitorId);
    }

    public void onConnectionHandlingFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.connectionHandling.failure(duration, timeUnit);
    }

    public void onConnectionHandlingSuccess(long duration, TimeUnit timeUnit) {
        this.connectionHandling.success(duration, timeUnit);
    }

    public void onConnectionHandlingStart(long duration, TimeUnit timeUnit) {
        this.connectionHandling.start(duration, timeUnit);
    }

    public void onConnectionCloseStart() {
        this.connectionClose.start();
    }

    public void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
        this.connectionClose.success(duration, timeUnit);
    }

    public void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.connectionClose.failure(duration, timeUnit);
    }

    public void onNewClientConnected() {
        this.connectionAccept.increment();
    }

    public void onByteRead(long bytesRead) {
        this.bytesRead.increment(bytesRead);
    }

    public void onByteWritten(long bytesWritten) {
        this.bytesWritten.increment(bytesWritten);
    }

    public void onFlushComplete(long duration, TimeUnit timeUnit) {
        this.flush.success(duration, timeUnit);
    }

    public void onFlushStart() {
        this.flush.start();
    }

    public void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.write.failure(duration, timeUnit);
    }

    public void onWriteSuccess(long duration, TimeUnit timeUnit) {
        this.write.success(duration, timeUnit);
    }

    public void onWriteStart() {
        this.write.start();
    }
}

