/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.ws.server;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.reactivex.netty.protocol.http.ws.server.WebSocketHandler;
import io.reactivex.netty.protocol.http.ws.server.WebSocketHandshaker;
import io.reactivex.netty.protocol.http.ws.server.Ws7To13UpgradeHandler;
import rx.Observable;
import rx.Subscriber;

final class V7to13Handshaker
extends WebSocketHandshaker {
    private final State state;
    private final HttpServerRequest<?> request;
    private final WebSocketHandler handler;

    private V7to13Handshaker(final State state, final HttpServerRequest<?> request, final WebSocketHandler handler) {
        super(new Observable.OnSubscribe<Void>(){

            public void call(Subscriber<? super Void> subscriber) {
                state.upgradeResponse.unsafeNettyChannel().pipeline().fireUserEventTriggered((Object)new Ws7To13UpgradeHandler.WebSocket7To13UpgradeAcceptedEvent(subscriber, handler, state, request));
            }
        });
        this.state = state;
        this.request = request;
        this.handler = handler;
    }

    @Override
    public WebSocketHandshaker subprotocol(String ... subprotocols) {
        return new V7to13Handshaker(new State(this.state, subprotocols), this.request, this.handler);
    }

    @Override
    public WebSocketHandshaker allowExtensions(boolean allowExtensions) {
        return new V7to13Handshaker(new State(this.state, allowExtensions), this.request, this.handler);
    }

    @Override
    public WebSocketHandshaker location(String webSocketLocation) {
        return new V7to13Handshaker(new State(this.state, new String[]{webSocketLocation}), this.request, this.handler);
    }

    @Override
    public WebSocketHandshaker maxFramePayloadLength(int maxFramePayloadLength) {
        return new V7to13Handshaker(new State(this.state, maxFramePayloadLength), this.request, this.handler);
    }

    static V7to13Handshaker createNew(WebSocketVersion version, HttpServerRequest<?> request, HttpServerResponse<?> upgradeResponse, WebSocketHandler handler) {
        return new V7to13Handshaker(new State(version, request, upgradeResponse), request, handler);
    }

    static final class State {
        private final WebSocketVersion version;
        private final HttpServerResponse<?> upgradeResponse;
        private final String[] supportedSubProtocols;
        private final String locationForV00;
        private final boolean allowExtensions;
        private final int maxFramePayloadLength;
        private final String secWSkey;
        private final String requestSubProtocols;

        private State(WebSocketVersion version, HttpServerRequest<?> request, HttpServerResponse<?> upgradeResponse) {
            this(State.getKey(request), State.getRequestedProtocols(request), version, upgradeResponse, null, null, true, 65536);
        }

        private State(State current, String ... subprotocols) {
            this(current.secWSkey, current.requestSubProtocols, current.version, current.upgradeResponse, subprotocols, current.locationForV00, current.allowExtensions, current.maxFramePayloadLength);
        }

        private State(State current, int maxFramePayloadLength) {
            this(current.secWSkey, current.requestSubProtocols, current.version, current.upgradeResponse, current.supportedSubProtocols, current.locationForV00, current.allowExtensions, maxFramePayloadLength);
        }

        private State(State current, boolean allowExtensions) {
            this(current.secWSkey, current.requestSubProtocols, current.version, current.upgradeResponse, current.supportedSubProtocols, current.locationForV00, allowExtensions, current.maxFramePayloadLength);
        }

        private State(String secWSkey, String requestSubProtocols, WebSocketVersion version, HttpServerResponse<?> upgradeResponse, String[] supportedSubProtocols, String locationForV00, boolean allowExtensions, int maxFramePayloadLength) {
            this.secWSkey = secWSkey;
            this.requestSubProtocols = requestSubProtocols;
            this.version = version;
            this.upgradeResponse = upgradeResponse;
            this.supportedSubProtocols = supportedSubProtocols;
            this.locationForV00 = locationForV00;
            this.allowExtensions = allowExtensions;
            this.maxFramePayloadLength = maxFramePayloadLength;
        }

        private static String getRequestedProtocols(HttpServerRequest<?> request) {
            return request.getHeader((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL);
        }

        private static String getKey(HttpServerRequest<?> request) {
            return request.getHeader((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY);
        }

        public WebSocketVersion getVersion() {
            return this.version;
        }

        public HttpServerResponse<?> getUpgradeResponse() {
            return this.upgradeResponse;
        }

        public String[] getSupportedSubProtocols() {
            return this.supportedSubProtocols;
        }

        public String getLocationForV00() {
            return this.locationForV00;
        }

        public boolean isAllowExtensions() {
            return this.allowExtensions;
        }

        public int getMaxFramePayloadLength() {
            return this.maxFramePayloadLength;
        }

        public String getSecWSkey() {
            return this.secWSkey;
        }

        public String getRequestSubProtocols() {
            return this.requestSubProtocols;
        }
    }
}

