/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.ws.client.internal;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.reactivex.netty.protocol.http.client.internal.HttpClientRequestImpl;
import io.reactivex.netty.protocol.http.client.internal.RawRequest;
import io.reactivex.netty.protocol.http.ws.client.WebSocketRequest;
import io.reactivex.netty.protocol.http.ws.client.WebSocketResponse;
import io.reactivex.netty.protocol.http.ws.client.internal.WebSocketResponseImpl;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;

public final class WebSocketRequestImpl<O>
extends WebSocketRequest<O> {
    private final String[] subProtocolsRequested;
    private final WebSocketVersion version;
    private final HttpClientRequest<?, O> httpRequest;

    private WebSocketRequestImpl(HttpClientRequest<?, O> httpRequest) {
        this(httpRequest, null, WebSocketVersion.V13);
    }

    private WebSocketRequestImpl(final HttpClientRequest<?, O> httpRequest, String[] subProtocolsRequested, WebSocketVersion version) {
        super(new Observable.OnSubscribe<WebSocketResponse<O>>(){

            public void call(Subscriber<? super WebSocketResponse<O>> subscriber) {
                httpRequest.map(new Func1<HttpClientResponse<O>, WebSocketResponseImpl<O>>(){

                    public WebSocketResponseImpl<O> call(HttpClientResponse<O> response) {
                        return new WebSocketResponseImpl(response);
                    }
                }).unsafeSubscribe(subscriber);
            }
        });
        this.httpRequest = httpRequest;
        this.subProtocolsRequested = subProtocolsRequested;
        this.version = version;
    }

    public String[] getSubProtocolsRequested() {
        return this.subProtocolsRequested;
    }

    @Override
    public WebSocketRequestImpl<O> requestSubProtocols(String ... subProtocols) {
        return new WebSocketRequestImpl<O>(this.httpRequest.setHeader((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, WebSocketRequestImpl.expectedSubProtocol(subProtocols)), subProtocols, this.version);
    }

    @Override
    public WebSocketRequestImpl<O> version(int version) {
        WebSocketVersion webSocketVersion;
        switch (version) {
            case 7: {
                webSocketVersion = WebSocketVersion.V07;
                break;
            }
            case 8: {
                webSocketVersion = WebSocketVersion.V08;
                break;
            }
            case 13: {
                webSocketVersion = WebSocketVersion.V13;
                break;
            }
            default: {
                webSocketVersion = WebSocketVersion.UNKNOWN;
            }
        }
        return new WebSocketRequestImpl<O>(this.httpRequest.setHeader((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, version), this.subProtocolsRequested, webSocketVersion);
    }

    public static <O> WebSocketRequestImpl<O> createNew(HttpClientRequestImpl<?, O> httpRequest) {
        HttpClientRequest upgradeRequest = httpRequest.addHeader((CharSequence)HttpHeaderNames.UPGRADE, HttpHeaderValues.WEBSOCKET);
        RawRequest rawRequest = ((HttpClientRequestImpl)upgradeRequest).unsafeRawRequest();
        HttpRequest headers = rawRequest.getHeaders();
        headers.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE);
        headers.headers().add((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)WebSocketVersion.V13.toHttpHeaderValue());
        return new WebSocketRequestImpl<O>(upgradeRequest);
    }

    private static String expectedSubProtocol(String[] subProtocols) {
        if (null == subProtocols || subProtocols.length == 0) {
            return null;
        }
        if (subProtocols.length == 1) {
            return subProtocols[0];
        }
        StringBuilder builder = new StringBuilder();
        for (String subProtocol : subProtocols) {
            if (builder.length() != 0) {
                builder.append(',');
            }
            builder.append(subProtocol);
        }
        return builder.toString();
    }
}

