/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.util.concurrent.EventExecutorGroup;
import io.reactivex.netty.events.EventSource;
import io.reactivex.netty.protocol.http.server.HttpServerImpl;
import io.reactivex.netty.protocol.http.server.RequestHandler;
import io.reactivex.netty.protocol.http.server.events.HttpServerEventsListener;
import io.reactivex.netty.protocol.tcp.server.TcpServer;
import io.reactivex.netty.ssl.SslCodec;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;

public abstract class HttpServer<I, O>
implements EventSource<HttpServerEventsListener> {
    public abstract <T> HttpServer<I, O> channelOption(ChannelOption<T> var1, T var2);

    public abstract <T> HttpServer<I, O> clientChannelOption(ChannelOption<T> var1, T var2);

    public abstract <II, OO> HttpServer<II, OO> addChannelHandlerFirst(String var1, Func0<ChannelHandler> var2);

    public abstract <II, OO> HttpServer<II, OO> addChannelHandlerFirst(EventExecutorGroup var1, String var2, Func0<ChannelHandler> var3);

    public abstract <II, OO> HttpServer<II, OO> addChannelHandlerLast(String var1, Func0<ChannelHandler> var2);

    public abstract <II, OO> HttpServer<II, OO> addChannelHandlerLast(EventExecutorGroup var1, String var2, Func0<ChannelHandler> var3);

    public abstract <II, OO> HttpServer<II, OO> addChannelHandlerBefore(String var1, String var2, Func0<ChannelHandler> var3);

    public abstract <II, OO> HttpServer<II, OO> addChannelHandlerBefore(EventExecutorGroup var1, String var2, String var3, Func0<ChannelHandler> var4);

    public abstract <II, OO> HttpServer<II, OO> addChannelHandlerAfter(String var1, String var2, Func0<ChannelHandler> var3);

    public abstract <II, OO> HttpServer<II, OO> addChannelHandlerAfter(EventExecutorGroup var1, String var2, String var3, Func0<ChannelHandler> var4);

    public abstract <II, OO> HttpServer<II, OO> pipelineConfigurator(Action1<ChannelPipeline> var1);

    public abstract HttpServer<I, O> secure(Func1<ByteBufAllocator, SSLEngine> var1);

    public abstract HttpServer<I, O> secure(SSLEngine var1);

    public abstract HttpServer<I, O> secure(SslCodec var1);

    public abstract HttpServer<I, O> unsafeSecure();

    @Deprecated
    public abstract HttpServer<I, O> enableWireLogging(LogLevel var1);

    public abstract HttpServer<I, O> enableWireLogging(String var1, LogLevel var2);

    public abstract HttpServer<I, O> sendHttp10ResponseFor10Request(boolean var1);

    public abstract int getServerPort();

    public abstract SocketAddress getServerAddress();

    public abstract HttpServer<I, O> start(RequestHandler<I, O> var1);

    public abstract void shutdown();

    public abstract void awaitShutdown();

    public abstract void awaitShutdown(long var1, TimeUnit var3);

    public static HttpServer<ByteBuf, ByteBuf> newServer() {
        return HttpServer._newServer((TcpServer<ByteBuf, ByteBuf>)TcpServer.newServer((int)0));
    }

    public static HttpServer<ByteBuf, ByteBuf> newServer(int port) {
        return HttpServer._newServer((TcpServer<ByteBuf, ByteBuf>)TcpServer.newServer((int)port));
    }

    public static HttpServer<ByteBuf, ByteBuf> newServer(int port, EventLoopGroup eventLoopGroup, Class<? extends ServerChannel> channelClass) {
        return HttpServer._newServer((TcpServer<ByteBuf, ByteBuf>)TcpServer.newServer((int)port, (EventLoopGroup)eventLoopGroup, (EventLoopGroup)eventLoopGroup, channelClass));
    }

    public static HttpServer<ByteBuf, ByteBuf> newServer(int port, EventLoopGroup serverGroup, EventLoopGroup clientGroup, Class<? extends ServerChannel> channelClass) {
        return HttpServer._newServer((TcpServer<ByteBuf, ByteBuf>)TcpServer.newServer((int)port, (EventLoopGroup)serverGroup, (EventLoopGroup)clientGroup, channelClass));
    }

    public static HttpServer<ByteBuf, ByteBuf> newServer(SocketAddress socketAddress) {
        return HttpServer._newServer((TcpServer<ByteBuf, ByteBuf>)TcpServer.newServer((SocketAddress)socketAddress));
    }

    public static HttpServer<ByteBuf, ByteBuf> newServer(SocketAddress socketAddress, EventLoopGroup eventLoopGroup, Class<? extends ServerChannel> channelClass) {
        return HttpServer._newServer((TcpServer<ByteBuf, ByteBuf>)TcpServer.newServer((SocketAddress)socketAddress, (EventLoopGroup)eventLoopGroup, (EventLoopGroup)eventLoopGroup, channelClass));
    }

    public static HttpServer<ByteBuf, ByteBuf> newServer(SocketAddress socketAddress, EventLoopGroup serverGroup, EventLoopGroup clientGroup, Class<? extends ServerChannel> channelClass) {
        return HttpServer._newServer((TcpServer<ByteBuf, ByteBuf>)TcpServer.newServer((SocketAddress)socketAddress, (EventLoopGroup)serverGroup, (EventLoopGroup)clientGroup, channelClass));
    }

    private static HttpServer<ByteBuf, ByteBuf> _newServer(TcpServer<ByteBuf, ByteBuf> tcpServer) {
        return HttpServerImpl.create(tcpServer);
    }
}

