/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.client.pool;

import io.reactivex.netty.client.pool.PoolLimitDeterminationStrategy;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class MaxConnectionsBasedStrategy
implements PoolLimitDeterminationStrategy {
    public static final int DEFAULT_MAX_CONNECTIONS = 1000;
    private final AtomicInteger limitEnforcer;
    private final AtomicInteger maxConnections;

    public MaxConnectionsBasedStrategy() {
        this(1000);
    }

    public MaxConnectionsBasedStrategy(int maxConnections) {
        this.maxConnections = new AtomicInteger(maxConnections);
        this.limitEnforcer = new AtomicInteger();
    }

    @Override
    public boolean acquireCreationPermit(long acquireStartTime, TimeUnit timeUnit) {
        int maxAllowedConnections;
        int currentValue;
        int newValue;
        while ((newValue = (currentValue = this.limitEnforcer.get()) + 1) <= (maxAllowedConnections = this.maxConnections.get())) {
            if (!this.limitEnforcer.compareAndSet(currentValue, newValue)) continue;
            return true;
        }
        return false;
    }

    public int incrementMaxConnections(int incrementBy) {
        return this.maxConnections.addAndGet(incrementBy);
    }

    public int decrementMaxConnections(int decrementBy) {
        return this.maxConnections.addAndGet(-1 * decrementBy);
    }

    public int getMaxConnections() {
        return this.maxConnections.get();
    }

    @Override
    public int getAvailablePermits() {
        return this.maxConnections.get() - this.limitEnforcer.get();
    }

    @Override
    public void releasePermit() {
        int currentValue;
        int newValue;
        while ((newValue = (currentValue = this.limitEnforcer.get()) - 1) >= 0 && !this.limitEnforcer.compareAndSet(currentValue, newValue)) {
        }
    }
}

