/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.client.pool;

import io.reactivex.netty.client.pool.PoolLimitDeterminationStrategy;
import java.util.concurrent.TimeUnit;

public class CompositePoolLimitDeterminationStrategy
implements PoolLimitDeterminationStrategy {
    private final PoolLimitDeterminationStrategy[] strategies;

    public CompositePoolLimitDeterminationStrategy(PoolLimitDeterminationStrategy ... strategies) {
        if (null == strategies || strategies.length == 0) {
            throw new IllegalArgumentException("Strategies can not be null or empty.");
        }
        for (PoolLimitDeterminationStrategy strategy : strategies) {
            if (null != strategy) continue;
            throw new IllegalArgumentException("No strategy can be null.");
        }
        this.strategies = strategies;
    }

    @Override
    public boolean acquireCreationPermit(long acquireStartTime, TimeUnit timeUnit) {
        for (int i = 0; i < this.strategies.length; ++i) {
            PoolLimitDeterminationStrategy strategy = this.strategies[i];
            if (strategy.acquireCreationPermit(acquireStartTime, timeUnit)) continue;
            if (i > 0) {
                for (int j = i - 1; j >= 0; --j) {
                    this.strategies[j].releasePermit();
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public int getAvailablePermits() {
        int minPermits = Integer.MAX_VALUE;
        for (PoolLimitDeterminationStrategy strategy : this.strategies) {
            int availablePermits = strategy.getAvailablePermits();
            minPermits = Math.min(minPermits, availablePermits);
        }
        return minPermits;
    }

    @Override
    public void releasePermit() {
        for (PoolLimitDeterminationStrategy strategy : this.strategies) {
            strategy.releasePermit();
        }
    }
}

