/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.util.AttributeKey;
import io.reactivex.netty.channel.AbstractConnectionToChannelBridge;
import io.reactivex.netty.channel.Connection;
import io.reactivex.netty.channel.ConnectionInputSubscriberResetEvent;
import io.reactivex.netty.channel.EmitConnectionEvent;
import io.reactivex.netty.client.events.ClientEventListener;
import io.reactivex.netty.client.pool.PooledConnection;
import io.reactivex.netty.events.EventAttributeKeys;
import io.reactivex.netty.events.EventPublisher;
import io.reactivex.netty.internal.ExecuteInEventloopAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Subscriber;
import rx.functions.Action0;
import rx.subscriptions.Subscriptions;

public class ClientConnectionToChannelBridge<R, W>
extends AbstractConnectionToChannelBridge<R, W> {
    public static final AttributeKey<Boolean> DISCARD_CONNECTION = AttributeKey.valueOf((String)"rxnetty_discard_connection");
    private static final Logger logger = LoggerFactory.getLogger(ClientConnectionToChannelBridge.class);
    private static final String HANDLER_NAME = "client-conn-channel-bridge";
    private EventPublisher eventPublisher;
    private ClientEventListener eventListener;
    private final boolean isSecure;
    private Channel channel;

    private ClientConnectionToChannelBridge(boolean isSecure) {
        super(HANDLER_NAME, EventAttributeKeys.CONNECTION_EVENT_LISTENER, EventAttributeKeys.EVENT_PUBLISHER);
        this.isSecure = isSecure;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.channel = ctx.channel();
        this.eventPublisher = (EventPublisher)this.channel.attr(EventAttributeKeys.EVENT_PUBLISHER).get();
        this.eventListener = (ClientEventListener)ctx.channel().attr(EventAttributeKeys.CLIENT_EVENT_LISTENER).get();
        if (null == this.eventPublisher) {
            logger.error("No Event publisher bound to the channel, closing channel.");
            ctx.channel().close();
            return;
        }
        if (this.eventPublisher.publishingEnabled() && null == this.eventListener) {
            logger.error("No Event listener bound to the channel and event publishing is enabled., closing channel.");
            ctx.channel().close();
            return;
        }
        super.handlerAdded(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (!this.isSecure) {
            this.userEventTriggered(ctx, EmitConnectionEvent.INSTANCE);
        }
        super.channelActive(ctx);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        super.userEventTriggered(ctx, evt);
        if (evt instanceof ConnectionReuseEvent) {
            ConnectionReuseEvent event = (ConnectionReuseEvent)evt;
            this.newConnectionReuseEvent(ctx.channel(), event);
        }
    }

    @Override
    protected void onNewReadSubscriber(Subscriber<? super R> subscriber) {
        subscriber.add(Subscriptions.create((Action0)new ExecuteInEventloopAction(this.channel){

            @Override
            public void run() {
                Connection connection;
                if (!ClientConnectionToChannelBridge.this.connectionInputSubscriberExists(ClientConnectionToChannelBridge.this.channel) && null != (connection = (Connection)ClientConnectionToChannelBridge.this.channel.attr(Connection.CONNECTION_ATTRIBUTE_KEY).get())) {
                    connection.closeNow();
                }
            }
        }));
    }

    private void newConnectionReuseEvent(Channel channel, ConnectionReuseEvent<R, W> event) {
        Subscriber<PooledConnection<R, W>> subscriber = event.getSubscriber();
        if (ClientConnectionToChannelBridge.isValidToEmit(subscriber)) {
            subscriber.onNext(event.getPooledConnection());
            this.checkEagerSubscriptionIfConfigured(channel);
        } else {
            event.getPooledConnection().close(false);
        }
    }

    public static <R, W> ClientConnectionToChannelBridge<R, W> addToPipeline(ChannelPipeline pipeline, boolean isSecure) {
        ClientConnectionToChannelBridge<R, W> toAdd = new ClientConnectionToChannelBridge<R, W>(isSecure);
        pipeline.addLast(HANDLER_NAME, toAdd);
        return toAdd;
    }

    public static final class PooledConnectionReleaseEvent {
        public static final PooledConnectionReleaseEvent INSTANCE = new PooledConnectionReleaseEvent();

        private PooledConnectionReleaseEvent() {
        }
    }

    public static final class ConnectionReuseEvent<I, O>
    implements ConnectionInputSubscriberResetEvent {
        private final Subscriber<? super PooledConnection<I, O>> subscriber;
        private final PooledConnection<I, O> pooledConnection;

        public ConnectionReuseEvent(Subscriber<? super PooledConnection<I, O>> subscriber, PooledConnection<I, O> pooledConnection) {
            this.subscriber = subscriber;
            this.pooledConnection = pooledConnection;
        }

        public Subscriber<? super PooledConnection<I, O>> getSubscriber() {
            return this.subscriber;
        }

        public PooledConnection<I, O> getPooledConnection() {
            return this.pooledConnection;
        }
    }
}

