/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class MarkAwarePipeline
implements ChannelPipeline {
    private boolean marked;
    private final ChannelPipeline delegate;

    public MarkAwarePipeline(ChannelPipeline delegate) {
        this.delegate = delegate;
    }

    public synchronized MarkAwarePipeline mark() {
        if (this.marked) {
            throw new IllegalStateException("Pipeline does not support nested marks.");
        }
        return this;
    }

    public synchronized MarkAwarePipeline markIfNotYetMarked() {
        if (!this.marked) {
            return this.mark();
        }
        return this;
    }

    public synchronized MarkAwarePipeline reset() {
        if (!this.marked) {
            return this;
        }
        this.marked = false;
        return this;
    }

    public synchronized boolean isMarked() {
        return this.marked;
    }

    public ChannelPipeline addFirst(String name, ChannelHandler handler) {
        this.delegate.addFirst(name, handler);
        return this;
    }

    public ChannelPipeline addFirst(EventExecutorGroup group, String name, ChannelHandler handler) {
        this.delegate.addFirst(group, name, handler);
        return this;
    }

    public ChannelPipeline addLast(String name, ChannelHandler handler) {
        this.delegate.addLast(name, handler);
        return this;
    }

    public ChannelPipeline addLast(EventExecutorGroup group, String name, ChannelHandler handler) {
        this.delegate.addLast(group, name, handler);
        return this;
    }

    public ChannelPipeline addBefore(String baseName, String name, ChannelHandler handler) {
        return this.delegate.addBefore(baseName, name, handler);
    }

    public ChannelPipeline addBefore(EventExecutorGroup group, String baseName, String name, ChannelHandler handler) {
        this.delegate.addBefore(group, baseName, name, handler);
        return this;
    }

    public ChannelPipeline addAfter(String baseName, String name, ChannelHandler handler) {
        this.delegate.addAfter(baseName, name, handler);
        return this;
    }

    public ChannelPipeline addAfter(EventExecutorGroup group, String baseName, String name, ChannelHandler handler) {
        this.delegate.addAfter(group, baseName, name, handler);
        return this;
    }

    public ChannelPipeline addFirst(ChannelHandler ... handlers) {
        this.delegate.addFirst(handlers);
        return this;
    }

    public ChannelPipeline addFirst(EventExecutorGroup group, ChannelHandler ... handlers) {
        this.delegate.addFirst(group, handlers);
        return this;
    }

    public ChannelPipeline addLast(ChannelHandler ... handlers) {
        this.delegate.addLast(handlers);
        return this;
    }

    public ChannelPipeline addLast(EventExecutorGroup group, ChannelHandler ... handlers) {
        this.delegate.addLast(group, handlers);
        return this;
    }

    public ChannelPipeline remove(ChannelHandler handler) {
        this.delegate.remove(handler);
        return this;
    }

    public ChannelHandler remove(String name) {
        return this.delegate.remove(name);
    }

    public <T extends ChannelHandler> T remove(Class<T> handlerType) {
        return (T)this.delegate.remove(handlerType);
    }

    public ChannelHandler removeFirst() {
        return this.delegate.removeFirst();
    }

    public ChannelHandler removeLast() {
        return this.delegate.removeLast();
    }

    public ChannelPipeline replace(ChannelHandler oldHandler, String newName, ChannelHandler newHandler) {
        this.delegate.replace(oldHandler, newName, newHandler);
        return this;
    }

    public ChannelHandler replace(String oldName, String newName, ChannelHandler newHandler) {
        return this.delegate.replace(oldName, newName, newHandler);
    }

    public <T extends ChannelHandler> T replace(Class<T> oldHandlerType, String newName, ChannelHandler newHandler) {
        return (T)this.delegate.replace(oldHandlerType, newName, newHandler);
    }

    public ChannelHandler first() {
        return this.delegate.first();
    }

    public ChannelHandlerContext firstContext() {
        return this.delegate.firstContext();
    }

    public ChannelHandler last() {
        return this.delegate.last();
    }

    public ChannelHandlerContext lastContext() {
        return this.delegate.lastContext();
    }

    public ChannelHandler get(String name) {
        return this.delegate.get(name);
    }

    public <T extends ChannelHandler> T get(Class<T> handlerType) {
        return (T)this.delegate.get(handlerType);
    }

    public ChannelHandlerContext context(ChannelHandler handler) {
        return this.delegate.context(handler);
    }

    public ChannelHandlerContext context(String name) {
        return this.delegate.context(name);
    }

    public ChannelHandlerContext context(Class<? extends ChannelHandler> handlerType) {
        return this.delegate.context(handlerType);
    }

    public Channel channel() {
        return this.delegate.channel();
    }

    public List<String> names() {
        return this.delegate.names();
    }

    public Map<String, ChannelHandler> toMap() {
        return this.delegate.toMap();
    }

    public ChannelPipeline fireChannelRegistered() {
        this.delegate.fireChannelRegistered();
        return this;
    }

    public ChannelPipeline fireChannelUnregistered() {
        this.delegate.fireChannelUnregistered();
        return this;
    }

    public ChannelPipeline fireChannelActive() {
        this.delegate.fireChannelActive();
        return this;
    }

    public ChannelPipeline fireChannelInactive() {
        this.delegate.fireChannelInactive();
        return this;
    }

    public ChannelPipeline fireExceptionCaught(Throwable cause) {
        this.delegate.fireExceptionCaught(cause);
        return this;
    }

    public ChannelPipeline fireUserEventTriggered(Object event) {
        this.delegate.fireUserEventTriggered(event);
        return this;
    }

    public ChannelPipeline fireChannelRead(Object msg) {
        this.delegate.fireChannelRead(msg);
        return this;
    }

    public ChannelPipeline fireChannelReadComplete() {
        this.delegate.fireChannelReadComplete();
        return this;
    }

    public ChannelPipeline fireChannelWritabilityChanged() {
        this.delegate.fireChannelWritabilityChanged();
        return this;
    }

    public ChannelFuture bind(SocketAddress localAddress) {
        return this.delegate.bind(localAddress);
    }

    public ChannelFuture connect(SocketAddress remoteAddress) {
        return this.delegate.connect(remoteAddress);
    }

    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.delegate.connect(remoteAddress, localAddress);
    }

    public ChannelFuture disconnect() {
        return this.delegate.disconnect();
    }

    public ChannelFuture close() {
        return this.delegate.close();
    }

    public ChannelFuture deregister() {
        return this.delegate.deregister();
    }

    public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
        return this.delegate.bind(localAddress, promise);
    }

    public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
        return this.delegate.connect(remoteAddress, promise);
    }

    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        return this.delegate.connect(remoteAddress, localAddress, promise);
    }

    public ChannelFuture disconnect(ChannelPromise promise) {
        return this.delegate.disconnect(promise);
    }

    public ChannelFuture close(ChannelPromise promise) {
        return this.delegate.close(promise);
    }

    public ChannelFuture deregister(ChannelPromise promise) {
        return this.delegate.deregister(promise);
    }

    public ChannelOutboundInvoker read() {
        return this.delegate.read();
    }

    public ChannelFuture write(Object msg) {
        return this.delegate.write(msg);
    }

    public ChannelFuture write(Object msg, ChannelPromise promise) {
        return this.delegate.write(msg, promise);
    }

    public ChannelPipeline flush() {
        return this.delegate.flush();
    }

    public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
        return this.delegate.writeAndFlush(msg, promise);
    }

    public ChannelFuture writeAndFlush(Object msg) {
        return this.delegate.writeAndFlush(msg);
    }

    public ChannelPromise newPromise() {
        return this.delegate.newPromise();
    }

    public ChannelProgressivePromise newProgressivePromise() {
        return this.delegate.newProgressivePromise();
    }

    public ChannelFuture newSucceededFuture() {
        return this.delegate.newSucceededFuture();
    }

    public ChannelFuture newFailedFuture(Throwable cause) {
        return this.delegate.newFailedFuture(cause);
    }

    public ChannelPromise voidPromise() {
        return this.delegate.voidPromise();
    }

    public Iterator<Map.Entry<String, ChannelHandler>> iterator() {
        return this.delegate.iterator();
    }
}

