/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Action1;
import rx.functions.Func0;

public class DetachedChannelPipeline {
    private static final Logger logger = LoggerFactory.getLogger(DetachedChannelPipeline.class);
    private final LinkedList<HandlerHolder> holdersInOrder;
    private final Action1<ChannelPipeline> nullableTail;

    public DetachedChannelPipeline() {
        this(null);
    }

    public DetachedChannelPipeline(Action1<ChannelPipeline> nullableTail) {
        this.nullableTail = nullableTail;
        this.holdersInOrder = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DetachedChannelPipeline(DetachedChannelPipeline copyFrom, Action1<ChannelPipeline> nullableTail) {
        this.nullableTail = nullableTail;
        this.holdersInOrder = new LinkedList();
        LinkedList<HandlerHolder> linkedList = copyFrom.holdersInOrder;
        synchronized (linkedList) {
            for (HandlerHolder handlerHolder : copyFrom.holdersInOrder) {
                this.holdersInOrder.addLast(handlerHolder);
            }
        }
    }

    public ChannelInitializer<Channel> getChannelInitializer() {
        return new ChannelInitializer<Channel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                LinkedList linkedList = DetachedChannelPipeline.this.holdersInOrder;
                synchronized (linkedList) {
                    DetachedChannelPipeline.this.unguardedCopyToPipeline(pipeline);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToChannel(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        LinkedList<HandlerHolder> linkedList = this.holdersInOrder;
        synchronized (linkedList) {
            this.unguardedCopyToPipeline(pipeline);
        }
    }

    public DetachedChannelPipeline copy() {
        return this.copy(null);
    }

    public DetachedChannelPipeline copy(Action1<ChannelPipeline> newTail) {
        return new DetachedChannelPipeline(this, newTail);
    }

    public DetachedChannelPipeline addFirst(String name, Func0<ChannelHandler> handlerFactory) {
        return this._guardedAddFirst(new HandlerHolder(name, handlerFactory));
    }

    public DetachedChannelPipeline addFirst(EventExecutorGroup group, String name, Func0<ChannelHandler> handlerFactory) {
        return this._guardedAddFirst(new HandlerHolder(name, handlerFactory, group));
    }

    public DetachedChannelPipeline addLast(String name, Func0<ChannelHandler> handlerFactory) {
        return this._guardedAddLast(new HandlerHolder(name, handlerFactory));
    }

    public DetachedChannelPipeline addLast(EventExecutorGroup group, String name, Func0<ChannelHandler> handlerFactory) {
        return this._guardedAddLast(new HandlerHolder(name, handlerFactory, group));
    }

    public DetachedChannelPipeline addBefore(String baseName, String name, Func0<ChannelHandler> handlerFactory) {
        return this._guardedAddBefore(baseName, new HandlerHolder(name, handlerFactory));
    }

    public DetachedChannelPipeline addBefore(EventExecutorGroup group, String baseName, String name, Func0<ChannelHandler> handlerFactory) {
        return this._guardedAddBefore(baseName, new HandlerHolder(name, handlerFactory, group));
    }

    public DetachedChannelPipeline addAfter(String baseName, String name, Func0<ChannelHandler> handlerFactory) {
        return this._guardedAddAfter(baseName, new HandlerHolder(name, handlerFactory));
    }

    public DetachedChannelPipeline addAfter(EventExecutorGroup group, String baseName, String name, Func0<ChannelHandler> handlerFactory) {
        return this._guardedAddAfter(baseName, new HandlerHolder(name, handlerFactory, group));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SafeVarargs
    public final DetachedChannelPipeline addFirst(Func0<ChannelHandler> ... handlerFactories) {
        LinkedList<HandlerHolder> linkedList = this.holdersInOrder;
        synchronized (linkedList) {
            for (int i = handlerFactories.length - 1; i >= 0; --i) {
                Func0<ChannelHandler> handlerFactory = handlerFactories[i];
                this.holdersInOrder.addFirst(new HandlerHolder(handlerFactory));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SafeVarargs
    public final DetachedChannelPipeline addFirst(EventExecutorGroup group, Func0<ChannelHandler> ... handlerFactories) {
        LinkedList<HandlerHolder> linkedList = this.holdersInOrder;
        synchronized (linkedList) {
            for (int i = handlerFactories.length - 1; i >= 0; --i) {
                Func0<ChannelHandler> handlerFactory = handlerFactories[i];
                this.holdersInOrder.addFirst(new HandlerHolder(null, handlerFactory, group));
            }
        }
        return this;
    }

    @SafeVarargs
    public final DetachedChannelPipeline addLast(Func0<ChannelHandler> ... handlerFactories) {
        for (Func0<ChannelHandler> handlerFactory : handlerFactories) {
            this._guardedAddLast(new HandlerHolder(handlerFactory));
        }
        return this;
    }

    @SafeVarargs
    public final DetachedChannelPipeline addLast(EventExecutorGroup group, Func0<ChannelHandler> ... handlerFactories) {
        for (Func0<ChannelHandler> handlerFactory : handlerFactories) {
            this._guardedAddLast(new HandlerHolder(null, handlerFactory, group));
        }
        return this;
    }

    public DetachedChannelPipeline configure(Action1<ChannelPipeline> configurator) {
        this._guardedAddLast(new HandlerHolder(configurator));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(ChannelPipeline pipeline) {
        LinkedList<HandlerHolder> linkedList = this.holdersInOrder;
        synchronized (linkedList) {
            this.unguardedCopyToPipeline(pipeline);
        }
    }

    LinkedList<HandlerHolder> getHoldersInOrder() {
        return this.holdersInOrder;
    }

    private void unguardedCopyToPipeline(ChannelPipeline pipeline) {
        for (HandlerHolder holder : this.holdersInOrder) {
            if (holder.hasPipelineConfigurator()) {
                holder.getPipelineConfigurator().call((Object)pipeline);
                continue;
            }
            if (holder.hasGroup()) {
                if (holder.hasName()) {
                    pipeline.addLast(holder.getGroupIfConfigured(), holder.getNameIfConfigured(), (ChannelHandler)holder.getHandlerFactoryIfConfigured().call());
                    continue;
                }
                pipeline.addLast(holder.getGroupIfConfigured(), new ChannelHandler[]{(ChannelHandler)holder.getHandlerFactoryIfConfigured().call()});
                continue;
            }
            if (holder.hasName()) {
                pipeline.addLast(holder.getNameIfConfigured(), (ChannelHandler)holder.getHandlerFactoryIfConfigured().call());
                continue;
            }
            pipeline.addLast(new ChannelHandler[]{(ChannelHandler)holder.getHandlerFactoryIfConfigured().call()});
        }
        if (null != this.nullableTail) {
            this.nullableTail.call((Object)pipeline);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Channel pipeline in initializer: " + DetachedChannelPipeline.pipelineToString(pipeline));
        }
    }

    private HandlerHolder unguardedFindHandlerByName(String baseName, boolean leniant) {
        for (HandlerHolder handlerHolder : this.holdersInOrder) {
            if (!handlerHolder.hasName() || !handlerHolder.getNameIfConfigured().equals(baseName)) continue;
            return handlerHolder;
        }
        if (leniant) {
            return null;
        }
        throw new NoSuchElementException("No handler with name: " + baseName + " configured in the pipeline.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DetachedChannelPipeline _guardedAddFirst(HandlerHolder toAdd) {
        LinkedList<HandlerHolder> linkedList = this.holdersInOrder;
        synchronized (linkedList) {
            this.holdersInOrder.addFirst(toAdd);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DetachedChannelPipeline _guardedAddLast(HandlerHolder toAdd) {
        LinkedList<HandlerHolder> linkedList = this.holdersInOrder;
        synchronized (linkedList) {
            this.holdersInOrder.addLast(toAdd);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DetachedChannelPipeline _guardedAddBefore(String baseName, HandlerHolder toAdd) {
        LinkedList<HandlerHolder> linkedList = this.holdersInOrder;
        synchronized (linkedList) {
            HandlerHolder before = this.unguardedFindHandlerByName(baseName, false);
            int indexOfBefore = this.holdersInOrder.indexOf(before);
            this.holdersInOrder.add(indexOfBefore, toAdd);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DetachedChannelPipeline _guardedAddAfter(String baseName, HandlerHolder toAdd) {
        LinkedList<HandlerHolder> linkedList = this.holdersInOrder;
        synchronized (linkedList) {
            HandlerHolder after = this.unguardedFindHandlerByName(baseName, false);
            int indexOfAfter = this.holdersInOrder.indexOf(after);
            this.holdersInOrder.add(indexOfAfter + 1, toAdd);
        }
        return this;
    }

    private static String pipelineToString(ChannelPipeline pipeline) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry handlerEntry : pipeline) {
            if (builder.length() == 0) {
                builder.append("[\n");
            } else {
                builder.append(" ==> ");
            }
            builder.append("{ name =>").append((String)handlerEntry.getKey()).append(", handler => ").append(handlerEntry.getValue()).append("}\n");
        }
        if (builder.length() > 0) {
            builder.append("}\n");
        }
        return builder.toString();
    }

    static class HandlerHolder {
        private final String nameIfConfigured;
        private final Func0<ChannelHandler> handlerFactoryIfConfigured;
        private final Action1<ChannelPipeline> pipelineConfigurator;
        private final EventExecutorGroup groupIfConfigured;

        HandlerHolder(Action1<ChannelPipeline> pipelineConfigurator) {
            this.pipelineConfigurator = pipelineConfigurator;
            this.nameIfConfigured = null;
            this.handlerFactoryIfConfigured = null;
            this.groupIfConfigured = null;
        }

        HandlerHolder(Func0<ChannelHandler> handlerFactory) {
            this(null, handlerFactory);
        }

        HandlerHolder(String name, Func0<ChannelHandler> handlerFactory) {
            this(name, handlerFactory, null);
        }

        HandlerHolder(String name, Func0<ChannelHandler> handlerFactory, EventExecutorGroup group) {
            this.nameIfConfigured = name;
            this.handlerFactoryIfConfigured = handlerFactory;
            this.groupIfConfigured = group;
            this.pipelineConfigurator = null;
        }

        public String getNameIfConfigured() {
            return this.nameIfConfigured;
        }

        public boolean hasName() {
            return null != this.nameIfConfigured;
        }

        public Func0<ChannelHandler> getHandlerFactoryIfConfigured() {
            return this.handlerFactoryIfConfigured;
        }

        public EventExecutorGroup getGroupIfConfigured() {
            return this.groupIfConfigured;
        }

        public boolean hasGroup() {
            return null != this.groupIfConfigured;
        }

        public Action1<ChannelPipeline> getPipelineConfigurator() {
            return this.pipelineConfigurator;
        }

        public boolean hasPipelineConfigurator() {
            return null != this.pipelineConfigurator;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HandlerHolder)) {
                return false;
            }
            HandlerHolder that = (HandlerHolder)o;
            if (this.groupIfConfigured != null ? !this.groupIfConfigured.equals(that.groupIfConfigured) : that.groupIfConfigured != null) {
                return false;
            }
            if (this.handlerFactoryIfConfigured != null ? !this.handlerFactoryIfConfigured.equals(that.handlerFactoryIfConfigured) : that.handlerFactoryIfConfigured != null) {
                return false;
            }
            if (this.nameIfConfigured != null ? !this.nameIfConfigured.equals(that.nameIfConfigured) : that.nameIfConfigured != null) {
                return false;
            }
            return !(this.pipelineConfigurator != null ? !this.pipelineConfigurator.equals(that.pipelineConfigurator) : that.pipelineConfigurator != null);
        }

        public int hashCode() {
            int result = this.nameIfConfigured != null ? this.nameIfConfigured.hashCode() : 0;
            result = 31 * result + (this.handlerFactoryIfConfigured != null ? this.handlerFactoryIfConfigured.hashCode() : 0);
            result = 31 * result + (this.pipelineConfigurator != null ? this.pipelineConfigurator.hashCode() : 0);
            result = 31 * result + (this.groupIfConfigured != null ? this.groupIfConfigured.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "HandlerHolder{nameIfConfigured='" + this.nameIfConfigured + '\'' + ", handlerFactoryIfConfigured=" + this.handlerFactoryIfConfigured + ", pipelineConfigurator=" + this.pipelineConfigurator + ", groupIfConfigured=" + this.groupIfConfigured + '}';
        }
    }
}

