/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import io.netty.util.concurrent.GenericFutureListener;
import io.reactivex.netty.channel.events.ConnectionEventListener;
import io.reactivex.netty.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytesInspector
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(BytesInspector.class);
    private final ConnectionEventListener eventListener;
    private final EventPublisher eventPublisher;

    public BytesInspector(EventPublisher eventPublisher, ConnectionEventListener eventListener) {
        this.eventPublisher = eventPublisher;
        this.eventListener = eventListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        try {
            if (ByteBuf.class.isAssignableFrom(msg.getClass())) {
                this.publishBytesRead((ByteBuf)msg);
            } else if (ByteBufHolder.class.isAssignableFrom(msg.getClass())) {
                ByteBufHolder holder = (ByteBufHolder)msg;
                this.publishBytesRead(holder.content());
            }
        }
        catch (Exception e) {
            logger.warn("Failed to publish bytes read metrics event. This does *not* stop the pipeline processing.", (Throwable)e);
        }
        finally {
            super.channelRead(ctx, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        try {
            if (ByteBuf.class.isAssignableFrom(msg.getClass())) {
                this.publishBytesWritten(((ByteBuf)msg).readableBytes(), promise);
            } else if (ByteBufHolder.class.isAssignableFrom(msg.getClass())) {
                this.publishBytesWritten(((ByteBufHolder)msg).content().readableBytes(), promise);
            } else if (FileRegion.class.isAssignableFrom(msg.getClass())) {
                this.publishBytesWritten(((FileRegion)msg).count(), promise);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to publish bytes write metrics event. This does *not* stop the pipeline processing.", (Throwable)e);
        }
        finally {
            super.write(ctx, msg, promise);
        }
    }

    protected void publishBytesWritten(final long bytesToWrite, ChannelPromise promise) {
        if (bytesToWrite <= 0L) {
            return;
        }
        if (this.eventPublisher.publishingEnabled()) {
            promise.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    BytesInspector.this.eventListener.onByteWritten(bytesToWrite);
                }
            });
        }
    }

    protected void publishBytesRead(ByteBuf byteBuf) {
        if (null != byteBuf) {
            this.eventListener.onByteRead(byteBuf.readableBytes());
        }
    }
}

