/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty;

import io.reactivex.netty.threads.RxEventLoopProvider;
import io.reactivex.netty.threads.SingleNioLoopProvider;

public final class RxNetty {
    private static volatile RxEventLoopProvider rxEventLoopProvider = new SingleNioLoopProvider(Runtime.getRuntime().availableProcessors());
    private static volatile boolean usingNativeTransport;
    private static volatile boolean disableEventPublishing;

    private RxNetty() {
    }

    public static RxEventLoopProvider useEventLoopProvider(RxEventLoopProvider provider) {
        RxEventLoopProvider oldProvider = rxEventLoopProvider;
        rxEventLoopProvider = provider;
        return oldProvider;
    }

    public static RxEventLoopProvider getRxEventLoopProvider() {
        return rxEventLoopProvider;
    }

    public static void useNativeTransportIfApplicable() {
        usingNativeTransport = true;
    }

    public static void disableNativeTransport() {
        usingNativeTransport = false;
    }

    public static void enableEventPublishing() {
        disableEventPublishing = false;
    }

    public static void disableEventPublishing() {
        disableEventPublishing = true;
    }

    public static boolean isEventPublishingDisabled() {
        return disableEventPublishing;
    }

    public static boolean isUsingNativeTransport() {
        return usingNativeTransport;
    }
}

