/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Func3;
import rx.functions.Func4;
import rx.observers.SerializedSubscriber;
import rx.subscriptions.SerialSubscription;

class OperatorTimeoutBase<T>
implements Observable.Operator<T, T> {
    private final FirstTimeoutStub<T> firstTimeoutStub;
    private final TimeoutStub<T> timeoutStub;
    private final Observable<? extends T> other;
    private final Scheduler scheduler;

    OperatorTimeoutBase(FirstTimeoutStub<T> firstTimeoutStub, TimeoutStub<T> timeoutStub, Observable<? extends T> other, Scheduler scheduler) {
        this.firstTimeoutStub = firstTimeoutStub;
        this.timeoutStub = timeoutStub;
        this.other = other;
        this.scheduler = scheduler;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> subscriber) {
        Scheduler.Worker inner = this.scheduler.createWorker();
        subscriber.add(inner);
        SerialSubscription serial = new SerialSubscription();
        subscriber.add(serial);
        SerializedSubscriber<? super T> synchronizedSubscriber = new SerializedSubscriber<T>(subscriber);
        TimeoutSubscriber timeoutSubscriber = new TimeoutSubscriber(synchronizedSubscriber, this.timeoutStub, serial, this.other, inner);
        serial.set((Subscription)this.firstTimeoutStub.call(timeoutSubscriber, 0L, inner));
        return timeoutSubscriber;
    }

    static final class TimeoutSubscriber<T>
    extends Subscriber<T> {
        private final SerialSubscription serial;
        private final Object gate = new Object();
        private final SerializedSubscriber<T> serializedSubscriber;
        private final TimeoutStub<T> timeoutStub;
        private final Observable<? extends T> other;
        private final Scheduler.Worker inner;
        volatile int terminated;
        volatile long actual;
        static final AtomicIntegerFieldUpdater<TimeoutSubscriber> TERMINATED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(TimeoutSubscriber.class, "terminated");
        static final AtomicLongFieldUpdater<TimeoutSubscriber> ACTUAL_UPDATER = AtomicLongFieldUpdater.newUpdater(TimeoutSubscriber.class, "actual");

        private TimeoutSubscriber(SerializedSubscriber<T> serializedSubscriber, TimeoutStub<T> timeoutStub, SerialSubscription serial, Observable<? extends T> other, Scheduler.Worker inner) {
            super(serializedSubscriber);
            this.serializedSubscriber = serializedSubscriber;
            this.timeoutStub = timeoutStub;
            this.serial = serial;
            this.other = other;
            this.inner = inner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T value) {
            boolean onNextWins = false;
            Object object = this.gate;
            synchronized (object) {
                if (this.terminated == 0) {
                    ACTUAL_UPDATER.incrementAndGet(this);
                    onNextWins = true;
                }
            }
            if (onNextWins) {
                this.serializedSubscriber.onNext(value);
                this.serial.set((Subscription)this.timeoutStub.call(this, this.actual, value, this.inner));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable error) {
            boolean onErrorWins = false;
            Object object = this.gate;
            synchronized (object) {
                if (TERMINATED_UPDATER.getAndSet(this, 1) == 0) {
                    onErrorWins = true;
                }
            }
            if (onErrorWins) {
                this.serial.unsubscribe();
                this.serializedSubscriber.onError(error);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            boolean onCompletedWins = false;
            Object object = this.gate;
            synchronized (object) {
                if (TERMINATED_UPDATER.getAndSet(this, 1) == 0) {
                    onCompletedWins = true;
                }
            }
            if (onCompletedWins) {
                this.serial.unsubscribe();
                this.serializedSubscriber.onCompleted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTimeout(long seqId) {
            long expected = seqId;
            boolean timeoutWins = false;
            Object object = this.gate;
            synchronized (object) {
                if (expected == this.actual && TERMINATED_UPDATER.getAndSet(this, 1) == 0) {
                    timeoutWins = true;
                }
            }
            if (timeoutWins) {
                if (this.other == null) {
                    this.serializedSubscriber.onError(new TimeoutException());
                } else {
                    this.other.unsafeSubscribe(this.serializedSubscriber);
                    this.serial.set(this.serializedSubscriber);
                }
            }
        }
    }

    static interface TimeoutStub<T>
    extends Func4<TimeoutSubscriber<T>, Long, T, Scheduler.Worker, Subscription> {
    }

    static interface FirstTimeoutStub<T>
    extends Func3<TimeoutSubscriber<T>, Long, Scheduler.Worker, Subscription> {
    }
}

