/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Subscriber;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Func1;
import rx.plugins.RxJavaPlugins;

public final class OperatorOnErrorFlatMap<T>
implements Observable.Operator<T, T> {
    private final Func1<OnErrorThrowable, ? extends Observable<? extends T>> resumeFunction;

    public OperatorOnErrorFlatMap(Func1<OnErrorThrowable, ? extends Observable<? extends T>> f) {
        this.resumeFunction = f;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        return new Subscriber<T>(child){

            @Override
            public void onCompleted() {
                child.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                try {
                    RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
                    Observable resume = (Observable)OperatorOnErrorFlatMap.this.resumeFunction.call(OnErrorThrowable.from(e));
                    resume.unsafeSubscribe(new Subscriber<T>(){

                        @Override
                        public void onCompleted() {
                        }

                        @Override
                        public void onError(Throwable e) {
                            child.onError(e);
                        }

                        @Override
                        public void onNext(T t) {
                            child.onNext(t);
                        }
                    });
                }
                catch (Throwable e2) {
                    child.onError(e2);
                }
            }

            @Override
            public void onNext(T t) {
                child.onNext(t);
            }
        };
    }
}

