/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.observers.SerializedObserver;
import rx.observers.SerializedSubscriber;
import rx.subjects.PublishSubject;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.RefCountSubscription;

public final class OnSubscribeGroupJoin<T1, T2, D1, D2, R>
implements Observable.OnSubscribe<R> {
    protected final Observable<T1> left;
    protected final Observable<T2> right;
    protected final Func1<? super T1, ? extends Observable<D1>> leftDuration;
    protected final Func1<? super T2, ? extends Observable<D2>> rightDuration;
    protected final Func2<? super T1, ? super Observable<T2>, ? extends R> resultSelector;

    public OnSubscribeGroupJoin(Observable<T1> left, Observable<T2> right, Func1<? super T1, ? extends Observable<D1>> leftDuration, Func1<? super T2, ? extends Observable<D2>> rightDuration, Func2<? super T1, ? super Observable<T2>, ? extends R> resultSelector) {
        this.left = left;
        this.right = right;
        this.leftDuration = leftDuration;
        this.rightDuration = rightDuration;
        this.resultSelector = resultSelector;
    }

    @Override
    public void call(Subscriber<? super R> child) {
        ResultManager ro = new ResultManager(new SerializedSubscriber<R>(child));
        child.add(ro);
        ro.init();
    }

    static final class WindowObservableFunc<T>
    implements Observable.OnSubscribe<T> {
        final RefCountSubscription refCount;
        final Observable<T> underlying;

        public WindowObservableFunc(Observable<T> underlying, RefCountSubscription refCount) {
            this.refCount = refCount;
            this.underlying = underlying;
        }

        @Override
        public void call(Subscriber<? super T> t1) {
            Subscription ref = this.refCount.get();
            WindowSubscriber wo = new WindowSubscriber(t1, ref);
            wo.add(ref);
            this.underlying.unsafeSubscribe(wo);
        }

        final class WindowSubscriber
        extends Subscriber<T> {
            final Subscriber<? super T> subscriber;
            private final Subscription ref;

            public WindowSubscriber(Subscriber<? super T> subscriber, Subscription ref) {
                super(subscriber);
                this.subscriber = subscriber;
                this.ref = ref;
            }

            @Override
            public void onNext(T args) {
                this.subscriber.onNext(args);
            }

            @Override
            public void onError(Throwable e) {
                this.subscriber.onError(e);
                this.ref.unsubscribe();
            }

            @Override
            public void onCompleted() {
                this.subscriber.onCompleted();
                this.ref.unsubscribe();
            }
        }
    }

    final class ResultManager
    implements Subscription {
        final RefCountSubscription cancel;
        final Subscriber<? super R> subscriber;
        final CompositeSubscription group;
        final Object guard = new Object();
        int leftIds;
        int rightIds;
        final Map<Integer, Observer<T2>> leftMap = new HashMap();
        final Map<Integer, T2> rightMap = new HashMap();
        boolean leftDone;
        boolean rightDone;

        public ResultManager(Subscriber<? super R> subscriber) {
            this.subscriber = subscriber;
            this.group = new CompositeSubscription();
            this.cancel = new RefCountSubscription(this.group);
        }

        public void init() {
            LeftObserver s1 = new LeftObserver();
            RightObserver s2 = new RightObserver();
            this.group.add(s1);
            this.group.add(s2);
            OnSubscribeGroupJoin.this.left.unsafeSubscribe(s1);
            OnSubscribeGroupJoin.this.right.unsafeSubscribe(s2);
        }

        @Override
        public void unsubscribe() {
            this.cancel.unsubscribe();
        }

        @Override
        public boolean isUnsubscribed() {
            return this.cancel.isUnsubscribed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void errorAll(Throwable e) {
            ArrayList list;
            Object object = this.guard;
            synchronized (object) {
                list = new ArrayList(this.leftMap.values());
                this.leftMap.clear();
                this.rightMap.clear();
            }
            for (Observer observer : list) {
                observer.onError(e);
            }
            this.subscriber.onError(e);
            this.cancel.unsubscribe();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void errorMain(Throwable e) {
            Object object = this.guard;
            synchronized (object) {
                this.leftMap.clear();
                this.rightMap.clear();
            }
            this.subscriber.onError(e);
            this.cancel.unsubscribe();
        }

        void complete(List<Observer<T2>> list) {
            if (list != null) {
                for (Observer o : list) {
                    o.onCompleted();
                }
                this.subscriber.onCompleted();
                this.cancel.unsubscribe();
            }
        }

        final class RightDurationObserver
        extends Subscriber<D2> {
            final int id;
            boolean once = true;

            public RightDurationObserver(int id) {
                this.id = id;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                if (this.once) {
                    this.once = false;
                    Object object = ResultManager.this.guard;
                    synchronized (object) {
                        ResultManager.this.rightMap.remove(this.id);
                    }
                    ResultManager.this.group.remove(this);
                }
            }

            @Override
            public void onError(Throwable e) {
                ResultManager.this.errorMain(e);
            }

            @Override
            public void onNext(D2 args) {
                this.onCompleted();
            }
        }

        final class LeftDurationObserver
        extends Subscriber<D1> {
            final int id;
            boolean once = true;

            public LeftDurationObserver(int id) {
                this.id = id;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                if (this.once) {
                    Observer gr;
                    this.once = false;
                    Object object = ResultManager.this.guard;
                    synchronized (object) {
                        gr = ResultManager.this.leftMap.remove(this.id);
                    }
                    if (gr != null) {
                        gr.onCompleted();
                    }
                    ResultManager.this.group.remove(this);
                }
            }

            @Override
            public void onError(Throwable e) {
                ResultManager.this.errorMain(e);
            }

            @Override
            public void onNext(D1 args) {
                this.onCompleted();
            }
        }

        final class RightObserver
        extends Subscriber<T2> {
            RightObserver() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(T2 args) {
                try {
                    ArrayList list;
                    int id;
                    Object object = ResultManager.this.guard;
                    synchronized (object) {
                        id = ResultManager.this.rightIds++;
                        ResultManager.this.rightMap.put(id, args);
                    }
                    Observable duration = OnSubscribeGroupJoin.this.rightDuration.call(args);
                    RightDurationObserver d2 = new RightDurationObserver(id);
                    ResultManager.this.group.add(d2);
                    duration.unsafeSubscribe(d2);
                    Object object2 = ResultManager.this.guard;
                    synchronized (object2) {
                        list = new ArrayList(ResultManager.this.leftMap.values());
                    }
                    for (Observer observer : list) {
                        observer.onNext(args);
                    }
                }
                catch (Throwable t) {
                    this.onError(t);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                ArrayList list = null;
                Object object = ResultManager.this.guard;
                synchronized (object) {
                    ResultManager.this.rightDone = true;
                    if (ResultManager.this.leftDone) {
                        list = new ArrayList(ResultManager.this.leftMap.values());
                        ResultManager.this.leftMap.clear();
                        ResultManager.this.rightMap.clear();
                    }
                }
                ResultManager.this.complete(list);
            }

            @Override
            public void onError(Throwable e) {
                ResultManager.this.errorAll(e);
            }
        }

        final class LeftObserver
        extends Subscriber<T1> {
            LeftObserver() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(T1 args) {
                try {
                    ArrayList rightMapValues;
                    int id;
                    PublishSubject subj = PublishSubject.create();
                    SerializedObserver subjSerial = new SerializedObserver(subj);
                    Object object = ResultManager.this.guard;
                    synchronized (object) {
                        id = ResultManager.this.leftIds++;
                        ResultManager.this.leftMap.put(id, subjSerial);
                    }
                    Observable window = Observable.create(new WindowObservableFunc(subj, ResultManager.this.cancel));
                    Observable duration = OnSubscribeGroupJoin.this.leftDuration.call(args);
                    LeftDurationObserver d1 = new LeftDurationObserver(id);
                    ResultManager.this.group.add(d1);
                    duration.unsafeSubscribe(d1);
                    Object result = OnSubscribeGroupJoin.this.resultSelector.call(args, window);
                    Object object2 = ResultManager.this.guard;
                    synchronized (object2) {
                        rightMapValues = new ArrayList(ResultManager.this.rightMap.values());
                    }
                    ResultManager.this.subscriber.onNext(result);
                    for (Object t2 : rightMapValues) {
                        subjSerial.onNext(t2);
                    }
                }
                catch (Throwable t) {
                    this.onError(t);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                ArrayList list = null;
                Object object = ResultManager.this.guard;
                synchronized (object) {
                    ResultManager.this.leftDone = true;
                    if (ResultManager.this.rightDone) {
                        list = new ArrayList(ResultManager.this.leftMap.values());
                        ResultManager.this.leftMap.clear();
                        ResultManager.this.rightMap.clear();
                    }
                }
                ResultManager.this.complete(list);
            }

            @Override
            public void onError(Throwable e) {
                ResultManager.this.errorAll(e);
            }
        }
    }
}

