/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.graphite;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.lang.Nullable;
import java.text.Normalizer;
import java.util.regex.Pattern;

public class GraphiteNamingConvention
implements NamingConvention {
    private static final Pattern blacklistedChars = Pattern.compile("[{}(),=\\[\\]/]");
    private final NamingConvention delegate;

    public GraphiteNamingConvention() {
        this(NamingConvention.camelCase);
    }

    public GraphiteNamingConvention(NamingConvention delegate) {
        this.delegate = delegate;
    }

    public String name(String name, Meter.Type type, @Nullable String baseUnit) {
        return this.sanitize(this.delegate.name(this.normalize(name), type, baseUnit));
    }

    public String tagKey(String key) {
        return this.sanitize(this.delegate.tagKey(this.normalize(key)));
    }

    public String tagValue(String value) {
        return this.sanitize(this.delegate.tagValue(this.normalize(value)));
    }

    private String normalize(String name) {
        return Normalizer.normalize(name, Normalizer.Form.NFKD);
    }

    private String sanitize(String delegated) {
        return blacklistedChars.matcher(delegated).replaceAll("_");
    }
}

