/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.atlas;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.util.MeterEquivalence;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;

public class SpectatorLongTaskTimer
extends AbstractMeter
implements LongTaskTimer {
    private final com.netflix.spectator.api.LongTaskTimer timer;

    SpectatorLongTaskTimer(Meter.Id id, com.netflix.spectator.api.LongTaskTimer timer) {
        super(id);
        this.timer = timer;
    }

    public LongTaskTimer.Sample start() {
        return new LongTaskTimer.Sample((LongTaskTimer)this, this.timer.start());
    }

    public long stop(long task) {
        return this.timer.stop(task);
    }

    public double duration(long task, TimeUnit unit) {
        return TimeUtils.nanosToUnit((double)this.timer.duration(task), (TimeUnit)unit);
    }

    public double duration(TimeUnit unit) {
        return TimeUtils.nanosToUnit((double)this.timer.duration(), (TimeUnit)unit);
    }

    public int activeTasks() {
        return this.timer.activeTasks();
    }

    public boolean equals(Object o) {
        return MeterEquivalence.equals((Meter)this, (Object)o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode((Meter)this);
    }
}

