/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.composite;

import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.AbstractCompositeMeter;
import io.micrometer.core.instrument.noop.NoopLongTaskTimer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

class CompositeLongTaskTimer
extends AbstractCompositeMeter<LongTaskTimer>
implements LongTaskTimer {
    private final AtomicLong nextTask = new AtomicLong(0L);
    private final ConcurrentMap<Long, Collection<LongTaskTimer.Sample>> timings = new ConcurrentHashMap<Long, Collection<LongTaskTimer.Sample>>();

    CompositeLongTaskTimer(Meter.Id id) {
        super(id);
    }

    @Override
    public LongTaskTimer.Sample start() {
        long task = this.nextTask.getAndIncrement();
        ArrayList samples = new ArrayList();
        this.forEachChild(ltt -> samples.add(ltt.start()));
        this.timings.put(task, samples);
        return new LongTaskTimer.Sample(this, task);
    }

    @Override
    public long stop(long task) {
        Collection childMappings = (Collection)this.timings.remove(task);
        long last = 0L;
        if (childMappings != null) {
            for (LongTaskTimer.Sample sample : childMappings) {
                last = sample.stop();
            }
        }
        return last;
    }

    @Override
    public double duration(long task, TimeUnit unit) {
        Collection childSamples = (Collection)this.timings.get(task);
        if (childSamples != null) {
            return childSamples.stream().findFirst().map(c -> c.duration(unit)).orElse(-1.0);
        }
        return -1.0;
    }

    @Override
    public double duration(TimeUnit unit) {
        return ((LongTaskTimer)this.firstChild()).duration(unit);
    }

    @Override
    public int activeTasks() {
        return ((LongTaskTimer)this.firstChild()).activeTasks();
    }

    @Override
    LongTaskTimer newNoopMeter() {
        return new NoopLongTaskTimer(this.getId());
    }

    @Override
    LongTaskTimer registerNewMeter(MeterRegistry registry) {
        return LongTaskTimer.builder(this.getId().getName()).tags(this.getId().getTags()).description(this.getId().getDescription()).register(registry);
    }
}

