/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.TimeWindowLatencyHistogram;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.util.MeterEquivalence;
import io.micrometer.core.lang.Nullable;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public abstract class AbstractTimer
extends AbstractMeter
implements Timer {
    protected final Clock clock;
    protected final TimeWindowLatencyHistogram histogram;
    private final DistributionStatisticConfig distributionStatisticConfig;
    private final TimeUnit baseTimeUnit;

    protected AbstractTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, TimeUnit baseTimeUnit) {
        super(id);
        this.clock = clock;
        this.distributionStatisticConfig = distributionStatisticConfig;
        this.histogram = new TimeWindowLatencyHistogram(clock, distributionStatisticConfig, pauseDetector);
        this.baseTimeUnit = baseTimeUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T recordCallable(Callable<T> f) throws Exception {
        long s = this.clock.monotonicTime();
        try {
            T t = f.call();
            return t;
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T record(Supplier<T> f) {
        long s = this.clock.monotonicTime();
        try {
            T t = f.get();
            return t;
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(Runnable f) {
        long s = this.clock.monotonicTime();
        try {
            f.run();
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public final void record(long amount, TimeUnit unit) {
        if (amount >= 0L) {
            this.histogram.recordLong(TimeUnit.NANOSECONDS.convert(amount, unit));
            this.recordNonNegative(amount, unit);
        }
    }

    protected abstract void recordNonNegative(long var1, TimeUnit var3);

    @Override
    public double percentile(double percentile, TimeUnit unit) {
        return this.histogram.percentile(percentile, unit);
    }

    @Override
    public double histogramCountAtValue(long valueNanos) {
        return this.histogram.histogramCountAtValue(valueNanos);
    }

    @Override
    public HistogramSnapshot takeSnapshot(boolean supportsAggregablePercentiles) {
        return this.histogram.takeSnapshot(this.count(), this.totalTime(TimeUnit.NANOSECONDS), this.max(TimeUnit.NANOSECONDS), supportsAggregablePercentiles);
    }

    @Override
    public TimeUnit baseTimeUnit() {
        return this.baseTimeUnit;
    }

    public boolean equals(@Nullable Object o) {
        return MeterEquivalence.equals(this, o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode(this);
    }

    public DistributionStatisticConfig statsConfig() {
        return this.distributionStatisticConfig;
    }

    @Override
    public void close() {
        this.histogram.close();
    }
}

