/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.runner;

import io.ebean.migration.runner.PlaceholderBuilder;
import java.util.HashMap;
import java.util.Map;

public class ScriptTransform {
    private final Map<String, String> placeholders = new HashMap<String, String>();

    public static String replace(String key, String value, String script) {
        return script.replace(key, value);
    }

    ScriptTransform(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.placeholders.put(this.wrapKey(entry.getKey()), entry.getValue());
        }
    }

    public static ScriptTransform build(String runPlaceholders, Map<String, String> runPlaceholderMap) {
        Map<String, String> map = PlaceholderBuilder.build(runPlaceholders, runPlaceholderMap);
        return new ScriptTransform(map);
    }

    private String wrapKey(String key) {
        return "${" + key + "}";
    }

    public String transform(String source) {
        for (Map.Entry<String, String> entry : this.placeholders.entrySet()) {
            source = source.replace(entry.getKey(), entry.getValue());
        }
        return source;
    }
}

