/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory;

import io.appium.java_client.pagefactory.AppiumElementLocator;
import io.appium.java_client.pagefactory.TimeOutDuration;
import io.appium.java_client.pagefactory.WithTimeout;
import io.appium.java_client.pagefactory.bys.builder.AppiumByBuilder;
import io.appium.java_client.pagefactory.locator.CacheableElementLocatorFactory;
import io.appium.java_client.pagefactory.locator.CacheableLocator;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;

class AppiumElementLocatorFactory
implements CacheableElementLocatorFactory {
    private final SearchContext searchContext;
    private final TimeOutDuration timeOutDuration;
    private final WebDriver originalWebDriver;
    private final AppiumByBuilder builder;

    public AppiumElementLocatorFactory(SearchContext searchContext, TimeOutDuration timeOutDuration, WebDriver originalWebDriver, AppiumByBuilder builder) {
        this.searchContext = searchContext;
        this.originalWebDriver = originalWebDriver;
        this.timeOutDuration = timeOutDuration;
        this.builder = builder;
    }

    @Override
    public CacheableLocator createLocator(Field field) {
        return this.createLocator((AnnotatedElement)field);
    }

    @Override
    public CacheableLocator createLocator(AnnotatedElement annotatedElement) {
        TimeOutDuration customDuration;
        if (annotatedElement.isAnnotationPresent(WithTimeout.class)) {
            WithTimeout withTimeout = annotatedElement.getAnnotation(WithTimeout.class);
            customDuration = new TimeOutDuration(withTimeout.time(), withTimeout.unit());
        } else {
            customDuration = this.timeOutDuration;
        }
        this.builder.setAnnotated(annotatedElement);
        By by = this.builder.buildBy();
        if (by != null) {
            return new AppiumElementLocator(this.searchContext, by, this.builder.isLookupCached(), customDuration, this.timeOutDuration, this.originalWebDriver);
        }
        return null;
    }
}

