/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.collect.ImmutableMap;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.DefaultGenericMobileElement;
import io.appium.java_client.IllegalCoordinatesException;
import io.appium.java_client.MobileCommand;
import io.appium.java_client.SwipeElementDirection;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.remote.FileDetector;

public abstract class MobileElement
extends DefaultGenericMobileElement<MobileElement> {
    protected FileDetector fileDetector;

    public Point getCenter() {
        Point upperLeft = this.getLocation();
        Dimension dimensions = this.getSize();
        return new Point(upperLeft.getX() + dimensions.getWidth() / 2, upperLeft.getY() + dimensions.getHeight() / 2);
    }

    @Override
    @Deprecated
    public void tap(int fingers, int duration) {
        ((AppiumDriver)AppiumDriver.class.cast(this.parent)).tap(fingers, this, duration);
    }

    @Override
    @Deprecated
    public void pinch() {
        ((AppiumDriver)AppiumDriver.class.cast(this.parent)).pinch(this);
    }

    @Override
    @Deprecated
    public void zoom() {
        ((AppiumDriver)AppiumDriver.class.cast(this.parent)).zoom(this);
    }

    @Override
    @Deprecated
    public void swipe(SwipeElementDirection direction, int duration) {
        direction.swipe((AppiumDriver)AppiumDriver.class.cast(this.parent), this, 0, 0, duration);
    }

    @Override
    @Deprecated
    public void swipe(SwipeElementDirection direction, int offsetFromStartBorder, int offsetFromEndBorder, int duration) throws IllegalCoordinatesException {
        direction.swipe((AppiumDriver)AppiumDriver.class.cast(this.parent), this, offsetFromStartBorder, offsetFromEndBorder, duration);
    }

    @Override
    public List<MobileElement> findElements(By by) {
        return super.findElements(by);
    }

    @Override
    public List<MobileElement> findElements(String by, String using) {
        return super.findElements(by, using);
    }

    @Override
    public List<MobileElement> findElementsById(String id) {
        return super.findElementsById(id);
    }

    @Override
    public List<MobileElement> findElementsByLinkText(String using) {
        return super.findElementsByLinkText(using);
    }

    @Override
    public List<MobileElement> findElementsByPartialLinkText(String using) {
        return super.findElementsByPartialLinkText(using);
    }

    @Override
    public List<MobileElement> findElementsByTagName(String using) {
        return super.findElementsByTagName(using);
    }

    @Override
    public List<MobileElement> findElementsByName(String using) {
        return super.findElementsByName(using);
    }

    @Override
    public List<MobileElement> findElementsByClassName(String using) {
        return super.findElementsByClassName(using);
    }

    @Override
    public List<MobileElement> findElementsByCssSelector(String using) {
        return super.findElementsByCssSelector(using);
    }

    @Override
    public List<MobileElement> findElementsByXPath(String using) {
        return super.findElementsByXPath(using);
    }

    @Override
    public List<MobileElement> findElementsByAccessibilityId(String using) {
        return super.findElementsByAccessibilityId(using);
    }

    public void setValue(String value) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"id", (Object)this.id).put((Object)"value", (Object)value);
        this.execute(MobileCommand.SET_VALUE, (Map)builder.build());
    }
}

