/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import groovy.lang.MetaMethod;
import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.Opcodes;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.classgen.ClassGeneratorException;
import org.codehaus.groovy.classgen.Variable;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;

public class BytecodeHelper
implements Opcodes {
    private MethodVisitor cv;

    public MethodVisitor getMethodVisitor() {
        return this.cv;
    }

    public BytecodeHelper(MethodVisitor cv) {
        this.cv = cv;
    }

    public void box(Class type) {
        if (type.isPrimitive() && type != Void.TYPE) {
            String returnString = "(" + BytecodeHelper.getTypeDescription(type.getName()) + ")Ljava/lang/Object;";
            this.cv.visitMethodInsn(184, BytecodeHelper.getClassInternalName(ScriptBytecodeAdapter.class.getName()), "box", returnString);
        }
    }

    public void quickBoxIfNecessary(Class cls) {
        String type = cls.getName();
        String descr = BytecodeHelper.getTypeDescription(type);
        if (cls == Boolean.TYPE) {
            this.boxBoolean();
        } else if (cls.isPrimitive() && cls != Void.TYPE) {
            if (cls == Integer.TYPE) {
                this.cv.visitMethodInsn(184, BytecodeHelper.getClassInternalName(ScriptBytecodeAdapter.class.getName()), "integerValue", "(I)Ljava/lang/Integer;");
                return;
            }
            String wrapperName = BytecodeHelper.getObjectTypeForPrimitive(type);
            String internName = BytecodeHelper.getClassInternalName(wrapperName);
            this.cv.visitTypeInsn(187, internName);
            this.cv.visitInsn(89);
            if (type.equals("double") || type.equals("long")) {
                this.cv.visitInsn(94);
                this.cv.visitInsn(88);
            } else {
                this.cv.visitInsn(93);
                this.cv.visitInsn(88);
            }
            this.cv.visitMethodInsn(183, internName, "<init>", "(" + descr + ")V");
        }
    }

    public void quickUnboxIfNecessary(Class cls) {
        String type = cls.getName();
        if (cls.isPrimitive() && cls != Void.TYPE) {
            String wrapperName = BytecodeHelper.getObjectTypeForPrimitive(type);
            String internName = BytecodeHelper.getClassInternalName(wrapperName);
            if (cls == Boolean.TYPE) {
                this.cv.visitTypeInsn(192, internName);
                this.cv.visitMethodInsn(182, internName, type + "Value", "()" + BytecodeHelper.getTypeDescription(type));
            } else {
                this.cv.visitTypeInsn(192, "java/lang/Number");
                this.cv.visitMethodInsn(182, "java/lang/Number", type + "Value", "()" + BytecodeHelper.getTypeDescription(type));
            }
        }
    }

    public void box(String type) {
        if (BytecodeHelper.isPrimitiveType(type) && !type.equals("void")) {
            String returnString = "(" + BytecodeHelper.getTypeDescription(type) + ")Ljava/lang/Object;";
            this.cv.visitMethodInsn(184, BytecodeHelper.getClassInternalName(ScriptBytecodeAdapter.class.getName()), "box", returnString);
        }
    }

    public void unbox(Class type) {
        if (type.isPrimitive() && type != Void.TYPE) {
            String returnString = "(Ljava/lang/Object;)" + BytecodeHelper.getTypeDescription(type.getName());
            this.cv.visitMethodInsn(184, BytecodeHelper.getClassInternalName(ScriptBytecodeAdapter.class.getName()), type.getName() + "Unbox", returnString);
        }
    }

    public void unbox(String type) {
        if (BytecodeHelper.isPrimitiveType(type) && !type.equals("void")) {
            String returnString = "(Ljava/lang/Object;)" + BytecodeHelper.getTypeDescription(type);
            this.cv.visitMethodInsn(184, BytecodeHelper.getClassInternalName(ScriptBytecodeAdapter.class.getName()), type + "Unbox", returnString);
        }
    }

    public static boolean isPrimitiveType(String type) {
        return type != null && (type.equals("boolean") || type.equals("byte") || type.equals("char") || type.equals("short") || type.equals("int") || type.equals("long") || type.equals("float") || type.equals("double"));
    }

    public static String getTypeDescription(String name) {
        if (name == null) {
            return "Ljava/lang/Object;";
        }
        if (name.equals("void")) {
            return "V";
        }
        if (name.startsWith("[")) {
            return name.replace('.', '/');
        }
        String prefix = "";
        if (name.endsWith("[]")) {
            prefix = "[";
            name = name.substring(0, name.length() - 2);
        }
        if (name.equals("int")) {
            return prefix + "I";
        }
        if (name.equals("long")) {
            return prefix + "J";
        }
        if (name.equals("short")) {
            return prefix + "S";
        }
        if (name.equals("float")) {
            return prefix + "F";
        }
        if (name.equals("double")) {
            return prefix + "D";
        }
        if (name.equals("byte")) {
            return prefix + "B";
        }
        if (name.equals("char")) {
            return prefix + "C";
        }
        if (name.equals("boolean")) {
            return prefix + "Z";
        }
        return prefix + "L" + name.replace('.', '/') + ";";
    }

    public static String getClassInternalName(String name) {
        if (name == null) {
            return "java/lang/Object";
        }
        String answer = name.replace('.', '/');
        if (answer.endsWith("[]")) {
            return "[" + answer.substring(0, answer.length() - 2);
        }
        return answer;
    }

    public static String getClassRegularName(String name) {
        if (name == null) {
            return "java.lang.Object";
        }
        if (name.startsWith("L") && (name = name.substring(1)).endsWith(";")) {
            name = name.substring(0, name.length() - 1);
        }
        String answer = name.replace('/', '.');
        return answer;
    }

    public static String getMethodDescriptor(String returnTypeName, Parameter[] paramTypeNames) {
        StringBuffer buffer = new StringBuffer("(");
        for (int i = 0; i < paramTypeNames.length; ++i) {
            buffer.append(BytecodeHelper.getTypeDescription(paramTypeNames[i].getType()));
        }
        buffer.append(")");
        buffer.append(BytecodeHelper.getTypeDescription(returnTypeName));
        return buffer.toString();
    }

    public static String getMethodDescriptor(Class returnType, Class[] paramTypes) {
        StringBuffer buffer = new StringBuffer("(");
        for (int i = 0; i < paramTypes.length; ++i) {
            buffer.append(BytecodeHelper.getTypeDescription(paramTypes[i]));
        }
        buffer.append(")");
        buffer.append(BytecodeHelper.getTypeDescription(returnType));
        return buffer.toString();
    }

    public static String getMethodDescriptor(Method meth) {
        return BytecodeHelper.getMethodDescriptor(meth.getReturnType(), meth.getParameterTypes());
    }

    public static String getTypeDescription(Class type) {
        if (type.isArray()) {
            return type.getName().replace('.', '/');
        }
        return BytecodeHelper.getTypeDescription(type.getName());
    }

    public static String[] getClassInternalNames(String[] names) {
        int size = names.length;
        String[] answer = new String[size];
        for (int i = 0; i < size; ++i) {
            answer[i] = BytecodeHelper.getClassInternalName(names[i]);
        }
        return answer;
    }

    protected void pushConstant(boolean value) {
        if (value) {
            this.cv.visitInsn(4);
        } else {
            this.cv.visitInsn(3);
        }
    }

    protected void pushConstant(int value) {
        switch (value) {
            case 0: {
                this.cv.visitInsn(3);
                break;
            }
            case 1: {
                this.cv.visitInsn(4);
                break;
            }
            case 2: {
                this.cv.visitInsn(5);
                break;
            }
            case 3: {
                this.cv.visitInsn(6);
                break;
            }
            case 4: {
                this.cv.visitInsn(7);
                break;
            }
            case 5: {
                this.cv.visitInsn(8);
                break;
            }
            default: {
                if (value >= -128 && value <= 127) {
                    this.cv.visitIntInsn(16, value);
                    break;
                }
                if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
                    this.cv.visitIntInsn(17, value);
                    break;
                }
                this.cv.visitLdcInsn(new Integer(value));
            }
        }
    }

    public void doCast(String type) {
        if (!type.equals("java.lang.Object")) {
            if (BytecodeHelper.isPrimitiveType(type) && !type.equals("void")) {
                this.unbox(type);
            } else {
                this.cv.visitTypeInsn(192, type.endsWith("[]") ? BytecodeHelper.getTypeDescription(type) : BytecodeHelper.getClassInternalName(type));
            }
        }
    }

    public void doCast(Class type) {
        String name = type.getName();
        if (type.isArray()) {
            name = type.getComponentType().getName() + "[]";
        }
        this.doCast(name);
    }

    public void load(String type, int idx) {
        if (type.equals("double")) {
            this.cv.visitVarInsn(24, idx);
        } else if (type.equals("float")) {
            this.cv.visitVarInsn(23, idx);
        } else if (type.equals("long")) {
            this.cv.visitVarInsn(22, idx);
        } else if (type.equals("boolean") || type.equals("char") || type.equals("byte") || type.equals("int") || type.equals("short")) {
            this.cv.visitVarInsn(21, idx);
        } else {
            this.cv.visitVarInsn(25, idx);
        }
    }

    public void load(Variable v) {
        this.load(v.getTypeName(), v.getIndex());
    }

    public void store(String type, int idx) {
        if (type.equals("double")) {
            this.cv.visitVarInsn(57, idx);
        } else if (type.equals("float")) {
            this.cv.visitVarInsn(56, idx);
        } else if (type.equals("long")) {
            this.cv.visitVarInsn(55, idx);
        } else if (type.equals("boolean") || type.equals("char") || type.equals("byte") || type.equals("int") || type.equals("short")) {
            this.cv.visitVarInsn(54, idx);
        } else {
            this.cv.visitVarInsn(58, idx);
        }
    }

    public void store(Variable v, boolean markStart) {
        String type = v.getTypeName();
        int idx = v.getIndex();
        if (type.equals("double")) {
            this.cv.visitVarInsn(57, idx);
        } else if (type.equals("float")) {
            this.cv.visitVarInsn(56, idx);
        } else if (type.equals("long")) {
            this.cv.visitVarInsn(55, idx);
        } else if (type.equals("boolean") || type.equals("char") || type.equals("byte") || type.equals("int") || type.equals("short")) {
            this.cv.visitVarInsn(54, idx);
        } else {
            this.cv.visitVarInsn(58, idx);
        }
    }

    public void store(Variable v) {
        this.store(v, false);
    }

    public static String getObjectTypeForPrimitive(String type) {
        if (type.equals("boolean")) {
            return Boolean.class.getName();
        }
        if (type.equals("byte")) {
            return Byte.class.getName();
        }
        if (type.equals("char")) {
            return Character.class.getName();
        }
        if (type.equals("short")) {
            return Short.class.getName();
        }
        if (type.equals("int")) {
            return Integer.class.getName();
        }
        if (type.equals("long")) {
            return Long.class.getName();
        }
        if (type.equals("float")) {
            return Float.class.getName();
        }
        if (type.equals("double")) {
            return Double.class.getName();
        }
        return type;
    }

    /*
     * WARNING - void declaration
     */
    void loadConstant(Object value) {
        if (value == null) {
            this.cv.visitInsn(1);
        } else if (value instanceof String) {
            this.cv.visitLdcInsn(value);
        } else if (value instanceof Number) {
            void var4_7;
            String methodType;
            Number n = (Number)value;
            String className = BytecodeHelper.getClassInternalName(value.getClass().getName());
            this.cv.visitTypeInsn(187, className);
            this.cv.visitInsn(89);
            if (n instanceof Double) {
                this.cv.visitLdcInsn(n);
                methodType = "(D)V";
            } else if (n instanceof Float) {
                this.cv.visitLdcInsn(n);
                methodType = "(F)V";
            } else if (n instanceof Long) {
                this.cv.visitLdcInsn(n);
                methodType = "(J)V";
            } else if (n instanceof BigDecimal) {
                this.cv.visitLdcInsn(n.toString());
                methodType = "(Ljava/lang/String;)V";
            } else if (n instanceof BigInteger) {
                this.cv.visitLdcInsn(n.toString());
                methodType = "(Ljava/lang/String;)V";
            } else if (n instanceof Integer) {
                this.pushConstant(n.intValue());
                methodType = "(I)V";
            } else {
                throw new ClassGeneratorException("Cannot generate bytecode for constant: " + value + " of type: " + value.getClass().getName() + ".  Numeric constant type not supported.");
            }
            this.cv.visitMethodInsn(183, className, "<init>", (String)var4_7);
        } else if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            String text = bool != false ? "TRUE" : "FALSE";
            this.cv.visitFieldInsn(178, "java/lang/Boolean", text, "Ljava/lang/Boolean;");
        } else if (value instanceof Class) {
            Class vc = (Class)value;
            if (!vc.getName().equals("java.lang.Void")) {
                throw new ClassGeneratorException("Cannot generate bytecode for constant: " + value + " of type: " + value.getClass().getName());
            }
        } else {
            throw new ClassGeneratorException("Cannot generate bytecode for constant: " + value + " of type: " + value.getClass().getName());
        }
    }

    public void loadVar(Variable variable, boolean holder) {
        String type = variable.getTypeName();
        int index = variable.getIndex();
        if (holder) {
            this.cv.visitVarInsn(25, index);
            this.cv.visitMethodInsn(182, "groovy/lang/Reference", "get", "()Ljava/lang/Object;");
        } else {
            this.cv.visitVarInsn(25, index);
        }
    }

    public void storeVar(Variable variable, boolean holder) {
        String type = variable.getTypeName();
        int index = variable.getIndex();
        if (holder) {
            this.cv.visitVarInsn(25, index);
            this.cv.visitInsn(95);
            this.cv.visitMethodInsn(182, "groovy/lang/Reference", "set", "(Ljava/lang/Object;)V");
        } else {
            this.store(variable.deriveBoxedVersion());
        }
    }

    public void putField(FieldNode fld) {
        this.putField(fld, BytecodeHelper.getClassInternalName(fld.getOwner()));
    }

    public void putField(FieldNode fld, String ownerName) {
        this.cv.visitFieldInsn(181, ownerName, fld.getName(), BytecodeHelper.getTypeDescription(fld.getType()));
    }

    public void loadThis() {
        this.cv.visitVarInsn(25, 0);
    }

    public static Class boxOnPrimitive(Class cls) {
        Class ans = cls;
        if (ans == null) {
            return null;
        }
        if (cls.isPrimitive() && cls != Void.TYPE) {
            if (cls == Integer.TYPE) {
                ans = Integer.class;
            } else if (cls == Byte.TYPE) {
                ans = Byte.class;
            } else if (cls == Character.TYPE) {
                ans = Character.class;
            } else if (cls == Short.TYPE) {
                ans = Short.class;
            } else if (cls == Boolean.TYPE) {
                ans = Boolean.class;
            } else if (cls == Float.TYPE) {
                ans = Float.class;
            } else if (cls == Long.TYPE) {
                ans = Long.class;
            } else if (cls == Double.TYPE) {
                ans = Double.class;
            }
        } else if (cls.isArray()) {
            int dimension = 0;
            Class<?> elemType = null;
            do {
                ++dimension;
            } while ((elemType = cls.getComponentType()).isArray());
            if (elemType.isPrimitive()) {
                Class boxElem = null;
                if (elemType == Integer.TYPE) {
                    boxElem = Integer.class;
                } else if (elemType == Byte.TYPE) {
                    boxElem = Byte.class;
                } else if (elemType == Character.TYPE) {
                    boxElem = Character.class;
                } else if (elemType == Short.TYPE) {
                    boxElem = Short.class;
                } else if (elemType == Boolean.TYPE) {
                    boxElem = Boolean.class;
                } else if (elemType == Float.TYPE) {
                    boxElem = Float.class;
                } else if (elemType == Long.TYPE) {
                    boxElem = Long.class;
                } else if (elemType == Double.TYPE) {
                    boxElem = Double.class;
                }
                String typeName = "";
                for (int i = 0; i < dimension; ++i) {
                    typeName = typeName + "[";
                }
                typeName = typeName + "L" + boxElem.getName() + ";";
                try {
                    return Class.forName(typeName);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return ans;
    }

    public void invoke(Method meth) {
        int op = Modifier.isStatic(meth.getModifiers()) ? 184 : (meth.getDeclaringClass().isInterface() ? 185 : 182);
        this.cv.visitMethodInsn(op, BytecodeHelper.getClassInternalName(meth.getDeclaringClass().getName()), meth.getName(), BytecodeHelper.getMethodDescriptor(meth));
    }

    public void boxBoolean() {
        Label l0 = new Label();
        this.cv.visitJumpInsn(153, l0);
        this.cv.visitFieldInsn(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
        Label l1 = new Label();
        this.cv.visitJumpInsn(167, l1);
        this.cv.visitLabel(l0);
        this.cv.visitFieldInsn(178, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
        this.cv.visitLabel(l1);
    }

    public static String getMethodDescriptor(MetaMethod metamethod) {
        return BytecodeHelper.getMethodDescriptor(metamethod.getReturnType(), metamethod.getParameterTypes());
    }

    public void mark(String msg) {
        this.cv.visitLdcInsn(msg);
        this.cv.visitInsn(87);
    }

    public static String formatNameForClassLoading(String name) {
        if (name.equals("int") || name.equals("long") || name.equals("short") || name.equals("float") || name.equals("double") || name.equals("byte") || name.equals("char") || name.equals("boolean") || name.equals("void")) {
            return name;
        }
        if (name == null) {
            return "java.lang.Object;";
        }
        if (name.startsWith("[")) {
            return name.replace('/', '.');
        }
        if (name.startsWith("L")) {
            if ((name = name.substring(1)).endsWith(";")) {
                name = name.substring(0, name.length() - 1);
            }
            return name.replace('/', '.');
        }
        String prefix = "";
        if (name.endsWith("[]")) {
            prefix = "[";
            if ((name = name.substring(0, name.length() - 2)).equals("int")) {
                return prefix + "I";
            }
            if (name.equals("long")) {
                return prefix + "J";
            }
            if (name.equals("short")) {
                return prefix + "S";
            }
            if (name.equals("float")) {
                return prefix + "F";
            }
            if (name.equals("double")) {
                return prefix + "D";
            }
            if (name.equals("byte")) {
                return prefix + "B";
            }
            if (name.equals("char")) {
                return prefix + "C";
            }
            if (name.equals("boolean")) {
                return prefix + "Z";
            }
            return prefix + "L" + name.replace('/', '.') + ";";
        }
        return name.replace('/', '.');
    }

    public void dup() {
        this.cv.visitInsn(89);
    }
}

