/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import groovy.lang.GroovyClassLoader;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.classgen.ClassGeneratorException;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;

public class CompileUnit {
    private List modules = new ArrayList();
    private Map classes = new HashMap();
    private CompilerConfiguration config;
    private ClassLoader classLoader;
    private CodeSource codeSource;
    private Map cachedClasses = new HashMap();
    public static final Object NO_CLASS = new Object();

    public CompileUnit(ClassLoader classLoader, CompilerConfiguration config) {
        this(classLoader, null, config);
    }

    public CompileUnit(ClassLoader classLoader, CodeSource codeSource, CompilerConfiguration config) {
        this.classLoader = classLoader;
        this.config = config;
        this.codeSource = codeSource;
    }

    public List getModules() {
        return this.modules;
    }

    public void addModule(ModuleNode node) {
        this.modules.add(node);
        node.setUnit(this);
        this.addClasses(node.classes);
    }

    public ClassNode getClass(String name) {
        return (ClassNode)this.classes.get(name);
    }

    public List getClasses() {
        ArrayList answer = new ArrayList();
        Iterator iter = this.modules.iterator();
        while (iter.hasNext()) {
            ModuleNode module = (ModuleNode)iter.next();
            answer.addAll(module.getClasses());
        }
        return answer;
    }

    public CompilerConfiguration getConfig() {
        return this.config;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public CodeSource getCodeSource() {
        return this.codeSource;
    }

    public Class loadClass(String type) throws ClassNotFoundException {
        ClassLoader loader;
        Throwable cause;
        Object obj = this.cachedClasses.get(type);
        if (obj == NO_CLASS) {
            throw new ClassNotFoundException(type);
        }
        if (obj != null) {
            return (Class)obj;
        }
        Class<?> answer = null;
        ClassLoader lastLoader = this.getClassLoader();
        try {
            answer = lastLoader.loadClass(type);
        }
        catch (ClassNotFoundException e) {
            cause = e.getCause();
            if (cause != null && cause instanceof CompilationFailedException) {
                throw new ClassGeneratorException("Error when compiling class: " + type + ". Reason: " + cause, cause);
            }
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        try {
            loader = Thread.currentThread().getContextClassLoader();
            if (answer == null && loader != lastLoader) {
                lastLoader = loader;
                answer = loader.loadClass(type);
            }
        }
        catch (ClassNotFoundException e1) {
            cause = e1.getCause();
            if (cause != null && cause instanceof CompilationFailedException) {
                throw new ClassGeneratorException("Error when compiling class: " + type + ". Reason: " + cause, cause);
            }
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        try {
            loader = this.getClass().getClassLoader();
            if (answer == null && loader != lastLoader) {
                lastLoader = loader;
                answer = loader.loadClass(type);
            }
        }
        catch (ClassNotFoundException e2) {
            cause = e2.getCause();
            if (cause != null && cause instanceof CompilationFailedException) {
                throw new ClassGeneratorException("Error when compiling class: " + type + ". Reason: " + cause, cause);
            }
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        try {
            if (answer == null) {
                answer = Class.forName(type);
            }
        }
        catch (ClassNotFoundException e2) {
            cause = e2.getCause();
            if (cause != null && cause instanceof CompilationFailedException) {
                throw new ClassGeneratorException("Error when compiling class: " + type + ". Reason: " + cause, cause);
            }
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        if (answer == null) {
            this.cachedClasses.put(type, NO_CLASS);
            throw new ClassNotFoundException(type);
        }
        if (answer != GroovyClassLoader.PARSING.class) {
            if (!type.equals(answer.getName())) {
                this.cachedClasses.put(type, NO_CLASS);
                System.out.println("Mismatch: answer.getName() = " + answer.getName() + ", type = " + type);
                throw new ClassNotFoundException(type);
            }
            this.cachedClasses.put(type, answer);
        }
        return answer;
    }

    void addClasses(List classList) {
        Iterator iter = classList.iterator();
        while (iter.hasNext()) {
            this.addClass((ClassNode)iter.next());
        }
    }

    public void addClass(ClassNode node) {
        String name = node.getName();
        if (this.classes.containsKey(name)) {
            throw new RuntimeException("Error: duplicate class declaration for name: " + name + " and class: " + node);
        }
        this.classes.put(name, node);
    }
}

