/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gram;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.codehaus.gram.Gram;
import org.codehaus.jam.JamService;
import org.codehaus.jam.JamServiceFactory;
import org.codehaus.jam.JamServiceParams;

public class GramTask
extends MatchingTask {
    private Path srcDir = null;
    private Path mToolpath = null;
    private Path mClasspath = null;
    private String mIncludes = "**/*.java";
    private File destDir;
    private File scriptDir;

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setScriptDir(File scriptDir) {
        this.scriptDir = scriptDir;
    }

    public void setSrcDir(Path srcDir) {
        this.srcDir = srcDir;
    }

    public void setToolpath(Path path) {
        if (this.mToolpath == null) {
            this.mToolpath = path;
        } else {
            this.mToolpath.append(path);
        }
    }

    public void setToolpathRef(Reference r) {
        this.createToolpath().setRefid(r);
    }

    public Path createToolpath() {
        if (this.mToolpath == null) {
            this.mToolpath = new Path(this.getProject());
        }
        return this.mToolpath.createPath();
    }

    public void setClasspath(Path path) {
        if (this.mClasspath == null) {
            this.mClasspath = path;
        } else {
            this.mClasspath.append(path);
        }
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path createClasspath() {
        if (this.mClasspath == null) {
            this.mClasspath = new Path(this.getProject());
        }
        return this.mClasspath.createPath();
    }

    public void execute() throws BuildException {
        int i;
        if (this.srcDir == null) {
            throw new BuildException("'srcDir' must be specified");
        }
        if (this.destDir == null) {
            throw new BuildException("'destDir' must be specified");
        }
        if (this.scriptDir == null) {
            throw new BuildException("'scriptDir' must be specified");
        }
        JamServiceFactory jamServiceFactory = JamServiceFactory.getInstance();
        JamServiceParams serviceParams = jamServiceFactory.createServiceParams();
        if (this.mToolpath != null) {
            File[] tcp = this.path2files(this.mToolpath);
            for (i = 0; i < tcp.length; ++i) {
                serviceParams.addToolClasspath(tcp[i]);
            }
        }
        if (this.mClasspath != null) {
            File[] cp = this.path2files(this.mClasspath);
            for (i = 0; i < cp.length; ++i) {
                serviceParams.addClasspath(cp[i]);
            }
        }
        serviceParams.includeSourcePattern(this.path2files(this.srcDir), this.mIncludes);
        try {
            JamService jam = jamServiceFactory.createService(serviceParams);
            Gram gram = new Gram(jam);
            this.log("Executing Groovy scripts:");
            DirectoryScanner ds = super.getDirectoryScanner(this.scriptDir);
            String[] files = ds.getIncludedFiles();
            for (int i2 = 0; i2 < files.length; ++i2) {
                String file = files[i2];
                this.log("Script: " + file);
                gram.execute(new File(this.scriptDir, file));
            }
            this.log("...done.");
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private File[] path2files(Path path) {
        String[] list = path.list();
        File[] out = new File[list.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = new File(list[i]).getAbsoluteFile();
        }
        return out;
    }
}

