/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.Code;

public class VarArgsProblems
extends BytecodeScanningDetector
implements StatelessDetector {
    private BugReporter bugReporter;
    private int state;
    public static final int SEEN_NOTHING = 0;
    public static final int SEEN_ICONST_1 = 1;
    public static final int SEEN_ANEWARRAY = 2;
    public static final int SEEN_DUP = 3;
    public static final int SEEN_ICONST_0 = 4;
    public static final int SEEN_ALOAD = 5;
    public static final int SEEN_AASTORE = 6;
    public static final int SEEN_GOTO = 7;
    Pattern primitiveArray = Pattern.compile("\\[[IJDFSCB]");

    public VarArgsProblems(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitCode(Code obj) {
        this.state = 0;
        super.visitCode(obj);
    }

    public void sawOpcode(int seen) {
        if (seen == 167 && this.getBranchOffset() == 4) {
            this.state = 7;
        } else {
            switch (this.state) {
                case 0: {
                    if (seen != 4) break;
                    this.state = 1;
                    break;
                }
                case 1: {
                    if (seen == 189 && this.primitiveArray.matcher(this.getClassConstantOperand()).matches()) {
                        this.state = 2;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                case 2: {
                    if (seen == 89) {
                        this.state = 3;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                case 3: {
                    if (seen == 3) {
                        this.state = 4;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                case 4: {
                    if (seen >= 42 && seen < 45 || seen == 25) {
                        this.state = 5;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                case 5: {
                    if (seen == 83) {
                        this.state = 6;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                case 6: {
                    if (seen == 184 || seen == 185 || seen == 183 || seen == 182) {
                        if (this.getSigConstantOperand().indexOf("Ljava/lang/Object;)") == -1) break;
                        int priority = 2;
                        if (this.getNameConstantOperand().equals("asList") && this.getClassConstantOperand().equals("java/util/Arrays")) {
                            priority = 1;
                        }
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "VA_PRIMITIVE_ARRAY_PASSED_TO_OBJECT_VARARG", priority).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                    this.state = 0;
                    break;
                }
                case 7: {
                    this.state = 0;
                    break;
                }
                default: {
                    throw new IllegalStateException("State " + this.state + " not expected");
                }
            }
        }
    }
}

