/*
 * Decompiled with CFR 0.152.
 */
package com.zenjava.javafx.maven.plugin;

import com.sun.javafx.tools.packager.CreateJarParams;
import com.sun.javafx.tools.packager.PackagerException;
import com.zenjava.javafx.maven.plugin.AbstractJfxToolsMojo;
import com.zenjava.javafx.maven.plugin.JavaDetectionTools;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class JarMojo
extends AbstractJfxToolsMojo {
    protected boolean css2bin;
    protected String preLoader;
    protected boolean updateExistingJar;
    protected boolean allPermissions;
    protected boolean jfxCallFromCLI;
    protected Map<String, String> manifestAttributes;
    protected boolean addPackagerJar;
    protected List<Dependency> classpathExcludes = new ArrayList<Dependency>();
    protected boolean classpathExcludesTransient;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.jfxCallFromCLI) {
            this.getLog().info((CharSequence)"call from CLI - skipping creation of JavaFX JAR for application");
            return;
        }
        this.getLog().info((CharSequence)"Building JavaFX JAR for application");
        Build build = this.project.getBuild();
        CreateJarParams createJarParams = new CreateJarParams();
        createJarParams.setOutdir(this.jfxAppOutputDir);
        if (!this.jfxMainAppJarName.toLowerCase().endsWith(".jar")) {
            this.getLog().error((CharSequence)"Please provide a proper value for <jfxMainAppJarName>! It has to end with \".jar\".");
            return;
        }
        createJarParams.setOutfile(this.jfxMainAppJarName);
        createJarParams.setApplicationClass(this.mainClass);
        createJarParams.setCss2bin(this.css2bin);
        createJarParams.setPreloader(this.preLoader);
        if (this.manifestAttributes == null) {
            this.manifestAttributes = new HashMap<String, String>();
        }
        createJarParams.setManifestAttrs(this.manifestAttributes);
        StringBuilder classpath = new StringBuilder();
        File libDir = new File(this.jfxAppOutputDir, "lib");
        if (!libDir.exists() && !libDir.mkdirs()) {
            throw new MojoExecutionException("Unable to create app lib dir: " + libDir);
        }
        if (this.updateExistingJar) {
            createJarParams.addResource(null, new File(build.getDirectory() + File.separator + build.getFinalName() + ".jar"));
        } else {
            createJarParams.addResource(new File(build.getOutputDirectory()), "");
        }
        try {
            if (this.checkIfJavaIsHavingPackagerJar()) {
                this.getLog().debug((CharSequence)"Check if packager.jar needs to be added");
                if (this.addPackagerJar) {
                    this.getLog().debug((CharSequence)"Searching for packager.jar ...");
                    String targetPackagerJarPath = "lib" + File.separator + "packager.jar";
                    for (Dependency dependency : this.project.getDependencies()) {
                        if (!"system".equalsIgnoreCase(dependency.getScope())) continue;
                        File packagerJarFile = new File(dependency.getSystemPath());
                        String packagerJarFilePathString = packagerJarFile.toPath().normalize().toString();
                        if (!packagerJarFile.exists() || !packagerJarFilePathString.endsWith(targetPackagerJarPath)) continue;
                        this.getLog().debug((CharSequence)String.format("Including packager.jar from system-scope: %s", packagerJarFilePathString));
                        File dest = new File(libDir, packagerJarFile.getName());
                        if (!dest.exists()) {
                            Files.copy(packagerJarFile.toPath(), dest.toPath(), new CopyOption[0]);
                        }
                        classpath.append("lib/").append(packagerJarFile.getName()).append(" ");
                    }
                } else {
                    this.getLog().debug((CharSequence)"No packager.jar will be added");
                }
            } else if (this.addPackagerJar) {
                this.getLog().warn((CharSequence)"Skipped checking for packager.jar. Please install at least Java 1.8u40 for using this feature.");
            }
            ArrayList brokenArtifacts = new ArrayList();
            this.project.getArtifacts().stream().filter(artifact -> {
                File artifactFile = artifact.getFile();
                return artifactFile.isFile() && artifactFile.canRead();
            }).filter(artifact -> {
                if (this.classpathExcludes.isEmpty()) {
                    return true;
                }
                boolean isListedInList = this.isListedInExclusionList((Artifact)artifact);
                return !isListedInList;
            }).forEach(artifact -> {
                File artifactFile = artifact.getFile();
                this.getLog().debug((CharSequence)String.format("Including classpath element: %s", artifactFile.getAbsolutePath()));
                File dest = new File(libDir, artifactFile.getName());
                if (!dest.exists()) {
                    try {
                        Files.copy(artifactFile.toPath(), dest.toPath(), new CopyOption[0]);
                    }
                    catch (IOException ex) {
                        this.getLog().warn((CharSequence)String.format("Couldn't read from file %s", artifactFile.getAbsolutePath()));
                        this.getLog().debug((Throwable)ex);
                        brokenArtifacts.add(artifactFile.getAbsolutePath());
                    }
                }
                classpath.append("lib/").append(artifactFile.getName()).append(" ");
            });
            if (!brokenArtifacts.isEmpty()) {
                throw new MojoExecutionException("Error copying dependencies for application");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying dependency for application", (Exception)e);
        }
        createJarParams.setClasspath(classpath.toString());
        if (this.allPermissions) {
            this.manifestAttributes.put("Permissions", "all-permissions");
        }
        try {
            this.getPackagerLib().packageAsJar(createJarParams);
        }
        catch (PackagerException e) {
            throw new MojoExecutionException("Unable to build JFX JAR for application", (Exception)((Object)e));
        }
        if (libDir.list().length == 0) {
            libDir.delete();
        }
    }

    private boolean checkIfJavaIsHavingPackagerJar() {
        if (JavaDetectionTools.IS_JAVA_8 && JavaDetectionTools.isAtLeastOracleJavaUpdateVersion(40)) {
            return true;
        }
        return JavaDetectionTools.IS_JAVA_9;
    }

    private boolean isListedInExclusionList(Artifact artifact) {
        return this.classpathExcludes.stream().filter(dependency -> {
            String dependencyTrailIdentifier = dependency.getGroupId() + ":" + dependency.getArtifactId() + ":";
            if (!this.classpathExcludesTransient) {
                return dependencyTrailIdentifier.startsWith(artifact.getGroupId() + ":" + artifact.getArtifactId() + ":");
            }
            return artifact.getDependencyTrail().stream().anyMatch(dependencyTrail -> dependencyTrail.startsWith(dependencyTrailIdentifier));
        }).count() > 0L;
    }
}

