/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;

public class RequestUtils {
    public static boolean isDefaultPort(URI uri) {
        String scheme = uri.getScheme().toLowerCase();
        int port = uri.getPort();
        return port <= 0 || port == 80 && scheme.equals("http") || port == 443 && scheme.equals("https");
    }

    public static String encodeUrl(String value, boolean path, boolean canonical) {
        String encoded;
        if (value == null || value.equals("")) {
            return "";
        }
        try {
            encoded = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Unable to UTF-8 encode url string component [" + value + "]", ex);
        }
        if (canonical) {
            encoded = encoded.replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
            if (path) {
                encoded = encoded.replace("%2F", "/");
            }
        }
        return encoded;
    }
}

