/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.saml;

import com.stormpath.sdk.api.ApiKey;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.http.QueryString;
import com.stormpath.sdk.impl.saml.SamlClaims;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.saml.SamlIdpUrlBuilder;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Date;
import java.util.UUID;

public class DefaultSamlIdpUrlBuilder
implements SamlIdpUrlBuilder {
    public static String SSO_LOGOUT_SUFFIX = "/logout";
    public final String ssoEndpoint;
    private final InternalDataStore internalDataStore;
    private final String applicationHref;
    private final SamlClaims claims;
    private boolean logout = false;

    public DefaultSamlIdpUrlBuilder(InternalDataStore internalDataStore, String applicationHref, String samlProviderEndpoint) {
        Assert.notNull((Object)internalDataStore, (String)"internalDataStore cannot be null.");
        Assert.hasText((String)samlProviderEndpoint, (String)"samlProviderEndpoint cannot be null or empty");
        this.ssoEndpoint = samlProviderEndpoint;
        this.internalDataStore = internalDataStore;
        this.applicationHref = applicationHref;
        this.claims = new SamlClaims();
    }

    public SamlIdpUrlBuilder setCallbackUri(String callbackUri) {
        this.claims.setCallbackUri(callbackUri);
        return this;
    }

    public SamlIdpUrlBuilder setState(String state) {
        this.claims.setState(state);
        return this;
    }

    public SamlIdpUrlBuilder setPath(String path) {
        this.claims.setPath(path);
        return this;
    }

    public SamlIdpUrlBuilder setOrganizationNameKey(String organizationNameKey) {
        this.claims.setOrganizationNameKey(organizationNameKey);
        return this;
    }

    public SamlIdpUrlBuilder setSpToken(String spToken) {
        this.claims.setSpToken(spToken);
        return this;
    }

    public SamlIdpUrlBuilder setAccountStoreHref(String accountStoreHref) {
        this.claims.setAccountStoreHref(accountStoreHref);
        return this;
    }

    public SamlIdpUrlBuilder addProperty(String name, Object value) {
        this.claims.put(name, value);
        return this;
    }

    public String build() {
        Assert.state((boolean)Strings.hasText((String)this.claims.getCallbackUri()), (String)"callbackUri cannot be null or empty.");
        String jti = UUID.randomUUID().toString();
        Date now = new Date();
        ApiKey apiKey = this.internalDataStore.getApiKey();
        JwtBuilder jwtBuilder = Jwts.builder().setClaims((Claims)this.claims).setId(jti).setIssuedAt(now).setIssuer(apiKey.getId()).setSubject(this.applicationHref);
        byte[] secret = apiKey.getSecret().getBytes(Strings.UTF_8);
        String jwt = jwtBuilder.setHeaderParam("typ", (Object)"JWT").setHeaderParam("kid", (Object)apiKey.getId()).signWith(SignatureAlgorithm.HS256, secret).compact();
        QueryString queryString = new QueryString();
        queryString.put("accessToken", jwt);
        StringBuilder urlBuilder = new StringBuilder(this.ssoEndpoint);
        if (this.logout) {
            urlBuilder.append(SSO_LOGOUT_SUFFIX);
        }
        return urlBuilder.append('?').append(queryString.toString()).toString();
    }
}

