/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.resource;

import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.resource.AbstractResource;
import com.stormpath.sdk.impl.resource.IntegerProperty;
import com.stormpath.sdk.impl.resource.Page;
import com.stormpath.sdk.resource.CollectionResource;
import com.stormpath.sdk.resource.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractCollectionResource<T extends Resource>
extends AbstractResource
implements CollectionResource<T> {
    public static final IntegerProperty OFFSET = new IntegerProperty("offset");
    public static final IntegerProperty LIMIT = new IntegerProperty("limit");
    public static final IntegerProperty SIZE = new IntegerProperty("size");
    public static final String ITEMS_PROPERTY_NAME = "items";
    private final Map<String, Object> queryParams;
    private AtomicBoolean firstPageQueryRequired = new AtomicBoolean();

    protected AbstractCollectionResource(InternalDataStore dataStore) {
        super(dataStore);
        this.queryParams = Collections.emptyMap();
    }

    protected AbstractCollectionResource(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
        this.queryParams = Collections.emptyMap();
    }

    protected AbstractCollectionResource(InternalDataStore dataStore, Map<String, Object> properties, Map<String, Object> queryParams) {
        super(dataStore, properties);
        this.queryParams = queryParams != null ? queryParams : Collections.emptyMap();
    }

    public static boolean isCollectionResource(Map<String, ?> props) {
        return AbstractCollectionResource.isMaterialized(props) && props.get(ITEMS_PROPERTY_NAME) instanceof Iterable;
    }

    public int getOffset() {
        return this.getInt(OFFSET);
    }

    public int getLimit() {
        return this.getInt(LIMIT);
    }

    public int getSize() {
        return this.getInt(SIZE);
    }

    public T single() {
        Iterator<T> iterator = this.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException("This list is empty while it was expected to contain one (and only one) element.");
        }
        Resource itemToReturn = (Resource)iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalStateException("Only a single resource was expected, but this list contains more than one item.");
        }
        return (T)itemToReturn;
    }

    protected abstract Class<T> getItemType();

    public Page<T> getCurrentPage() {
        Collection<Object> items = Collections.emptyList();
        Object value = this.getProperty(ITEMS_PROPERTY_NAME);
        if (value != null) {
            Collection vals;
            Collection c = null;
            if (value instanceof Map[]) {
                Map[] vals2 = (Map[])value;
                if (vals2.length > 0) {
                    c = Arrays.asList(vals2);
                }
            } else if (value instanceof Collection && (vals = (Collection)value).size() > 0) {
                c = vals;
            }
            if (c != null && !c.isEmpty()) {
                if (!this.getItemType().isInstance(c.iterator().next())) {
                    items = this.toResourceList(c, this.getItemType());
                    this.setProperty(ITEMS_PROPERTY_NAME, items, false);
                } else {
                    items = c;
                }
            }
        }
        return new DefaultPage(this.getOffset(), this.getLimit(), this.getSize(), items);
    }

    public Iterator<T> iterator() {
        return new PaginatedIterator(this, this.firstPageQueryRequired.getAndSet(true));
    }

    private Collection<T> toResourceList(Collection vals, Class<T> itemType) {
        ArrayList<T> list = new ArrayList<T>(vals.size());
        for (Object o : vals) {
            Map properties = (Map)o;
            T resource = this.toResource(itemType, properties);
            list.add(resource);
        }
        return list;
    }

    protected T toResource(Class<T> resourceClass, Map<String, Object> properties) {
        return this.getDataStore().instantiate(resourceClass, properties);
    }

    private static class DefaultPage<T>
    implements Page<T> {
        private final int offset;
        private final int limit;
        private final int size;
        private final Collection<T> items;

        DefaultPage(int offset, int limit, int size, Collection<T> items) {
            this.offset = offset;
            this.limit = limit;
            this.size = size;
            this.items = Collections.unmodifiableCollection(items);
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public int getLimit() {
            return this.limit;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public Collection<T> getItems() {
            return this.items;
        }
    }

    private class PaginatedIterator<T extends Resource>
    implements Iterator<T> {
        private AbstractCollectionResource<T> resource;
        private Page<T> currentPage;
        private Iterator<T> currentPageIterator;
        private int currentItemIndex;

        private PaginatedIterator(AbstractCollectionResource<T> resource, boolean firstPageQueryRequired) {
            if (firstPageQueryRequired) {
                this.resource = (AbstractCollectionResource)AbstractCollectionResource.this.getDataStore().getResource(resource.getHref(), resource.getClass(), ((AbstractCollectionResource)resource).queryParams);
                this.currentPage = this.resource.getCurrentPage();
            } else {
                this.resource = resource;
                this.currentPage = resource.getCurrentPage();
            }
            this.currentPageIterator = this.currentPage.getItems().iterator();
            this.currentItemIndex = 0;
        }

        @Override
        public boolean hasNext() {
            boolean exhaustedLimit;
            boolean hasNext = this.currentPageIterator.hasNext();
            int pageLimit = this.currentPage.getLimit();
            boolean bl = exhaustedLimit = this.currentItemIndex == pageLimit;
            if (!hasNext && exhaustedLimit) {
                boolean exhaustedSize;
                boolean bl2 = exhaustedSize = this.currentPage.getOffset() + pageLimit >= AbstractCollectionResource.this.getSize();
                if (!exhaustedSize) {
                    int offset = this.currentPage.getOffset() + pageLimit;
                    LinkedHashMap<String, Object> queryParams = new LinkedHashMap<String, Object>(((AbstractCollectionResource)this.resource).queryParams);
                    queryParams.put(OFFSET.getName(), offset);
                    queryParams.put(LIMIT.getName(), pageLimit);
                    AbstractCollectionResource nextResource = (AbstractCollectionResource)AbstractCollectionResource.this.getDataStore().getResource(this.resource.getHref(), this.resource.getClass(), queryParams);
                    Page nextPage = nextResource.getCurrentPage();
                    Iterator nextIterator = nextPage.getItems().iterator();
                    if (nextIterator.hasNext()) {
                        hasNext = true;
                        this.resource = nextResource;
                        this.currentPage = nextPage;
                        this.currentPageIterator = nextIterator;
                        this.currentItemIndex = 0;
                    }
                }
            }
            return hasNext;
        }

        @Override
        public T next() {
            Resource item = (Resource)this.currentPageIterator.next();
            ++this.currentItemIndex;
            return (T)item;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported.");
        }
    }
}

