/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.provider;

import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.provider.DefaultProviderAccountAccess;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.provider.ProviderAccountRequest;
import com.stormpath.sdk.provider.ProviderAccountResult;
import com.stormpath.sdk.provider.ProviderData;

public class ProviderAccountResolver {
    private InternalDataStore dataStore;

    public ProviderAccountResolver(InternalDataStore dataStore) {
        Assert.notNull((Object)dataStore, (String)"dataStore cannot be null");
        this.dataStore = dataStore;
    }

    public ProviderAccountResult resolveProviderAccount(String parentHref, ProviderAccountRequest request) {
        Assert.notNull((Object)parentHref, (String)"parentHref argument must be specified");
        Assert.notNull((Object)request, (String)"request argument cannot be null");
        Assert.notNull((Object)request.getProviderData(), (String)"request's providerData must be specified");
        DefaultProviderAccountAccess<ProviderData> providerAccountAccess = new DefaultProviderAccountAccess<ProviderData>(this.dataStore);
        providerAccountAccess.setProviderData(request.getProviderData());
        String href = parentHref + "/accounts";
        return this.dataStore.create(href, providerAccountAccess, ProviderAccountResult.class);
    }
}

