/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.provider;

import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.provider.AbstractProvider;
import com.stormpath.sdk.impl.provider.IdentityProviderType;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.impl.resource.ResourceReference;
import com.stormpath.sdk.impl.resource.StringProperty;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.provider.saml.SamlProvider;
import com.stormpath.sdk.saml.AttributeStatementMappingRules;
import com.stormpath.sdk.saml.SamlServiceProviderMetadata;
import java.util.Map;

public class DefaultSamlProvider
extends AbstractProvider
implements SamlProvider {
    static final StringProperty SSO_LOGIN_URL = new StringProperty("ssoLoginUrl");
    static final StringProperty SSO_LOGOUT_URL = new StringProperty("ssoLogoutUrl");
    static final StringProperty ENCODED_X509_SIGNING_CERT = new StringProperty("encodedX509SigningCert");
    static final StringProperty REQUEST_SIGNATURE_ALGORITHM = new StringProperty("requestSignatureAlgorithm");
    static final ResourceReference<AttributeStatementMappingRules> ATTRIBUTE_STATEMENT_MAPPING_RULES = new ResourceReference<AttributeStatementMappingRules>("attributeStatementMappingRules", AttributeStatementMappingRules.class);
    static final ResourceReference<SamlServiceProviderMetadata> SERVICE_PROVIDER_METADATA = new ResourceReference<SamlServiceProviderMetadata>("serviceProviderMetadata", SamlServiceProviderMetadata.class);
    static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultSamlProvider.createPropertyDescriptorMap(PROVIDER_ID, CREATED_AT, MODIFIED_AT, SSO_LOGIN_URL, SSO_LOGOUT_URL, ENCODED_X509_SIGNING_CERT, REQUEST_SIGNATURE_ALGORITHM, SERVICE_PROVIDER_METADATA, ATTRIBUTE_STATEMENT_MAPPING_RULES);

    public DefaultSamlProvider(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultSamlProvider(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    protected String getConcreteProviderId() {
        return IdentityProviderType.SAML.getNameKey();
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public String getSsoLoginUrl() {
        return this.getString(SSO_LOGIN_URL);
    }

    public String getSsoLogoutUrl() {
        return this.getString(SSO_LOGOUT_URL);
    }

    public String getEncodedX509SigningCert() {
        return this.getString(ENCODED_X509_SIGNING_CERT);
    }

    public String getRequestSignatureAlgorithm() {
        return this.getString(REQUEST_SIGNATURE_ALGORITHM);
    }

    public AttributeStatementMappingRules getAttributeStatementMappingRules() {
        return this.getResourceProperty(ATTRIBUTE_STATEMENT_MAPPING_RULES);
    }

    public void setAttributeStatementMappingRules(AttributeStatementMappingRules attributeStatementMappingRules) {
        Assert.notNull((Object)attributeStatementMappingRules, (String)"attributeStatementMappingRules cannot be null or empty.");
        this.setProperty(ATTRIBUTE_STATEMENT_MAPPING_RULES, (Object)attributeStatementMappingRules);
    }

    public SamlServiceProviderMetadata getServiceProviderMetadata() {
        return this.getResourceProperty(SERVICE_PROVIDER_METADATA);
    }

    public void setSsoLoginUrl(String ssoLoginUrl) {
        Assert.notNull((Object)ssoLoginUrl, (String)"ssoLoginUrl cannot be null or empty.");
        this.setProperty(SSO_LOGIN_URL, (Object)ssoLoginUrl);
    }

    public void setSsoLogoutUrl(String ssoLogoutUrl) {
        Assert.notNull((Object)ssoLogoutUrl, (String)"ssoLogoutUrl cannot be null or empty.");
        this.setProperty(SSO_LOGOUT_URL, (Object)ssoLogoutUrl);
    }

    public void setEncodedX509SigningCert(String encodedX509SigningCert) {
        Assert.notNull((Object)encodedX509SigningCert, (String)"encodedX509SigningCert cannot be null or empty.");
        this.setProperty(ENCODED_X509_SIGNING_CERT, (Object)encodedX509SigningCert);
    }

    public void setRequestSignatureAlgorithm(String requestSignatureAlgorithm) {
        Assert.notNull((Object)requestSignatureAlgorithm, (String)"requestSignatureAlgorithm cannot be null or empty.");
        this.setProperty(REQUEST_SIGNATURE_ALGORITHM, (Object)requestSignatureAlgorithm);
    }
}

