/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.organization;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.Accounts;
import com.stormpath.sdk.account.CreateAccountRequest;
import com.stormpath.sdk.directory.AccountStore;
import com.stormpath.sdk.directory.AccountStoreVisitor;
import com.stormpath.sdk.directory.Directories;
import com.stormpath.sdk.directory.Directory;
import com.stormpath.sdk.directory.DirectoryCriteria;
import com.stormpath.sdk.directory.DirectoryList;
import com.stormpath.sdk.group.CreateGroupRequest;
import com.stormpath.sdk.group.Group;
import com.stormpath.sdk.group.GroupCriteria;
import com.stormpath.sdk.group.GroupList;
import com.stormpath.sdk.group.Groups;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.resource.AbstractExtendableInstanceResource;
import com.stormpath.sdk.impl.resource.CollectionReference;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.impl.resource.ResourceReference;
import com.stormpath.sdk.impl.resource.StatusProperty;
import com.stormpath.sdk.impl.resource.StringProperty;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.organization.Organization;
import com.stormpath.sdk.organization.OrganizationAccountStoreMapping;
import com.stormpath.sdk.organization.OrganizationAccountStoreMappingCriteria;
import com.stormpath.sdk.organization.OrganizationAccountStoreMappingList;
import com.stormpath.sdk.organization.OrganizationStatus;
import com.stormpath.sdk.query.Criteria;
import com.stormpath.sdk.query.Criterion;
import com.stormpath.sdk.resource.ResourceException;
import com.stormpath.sdk.tenant.Tenant;
import java.util.Map;

public class DefaultOrganization
extends AbstractExtendableInstanceResource
implements Organization {
    static final StringProperty NAME = new StringProperty("name");
    static final StringProperty DESCRIPTION = new StringProperty("description");
    static final StringProperty NAME_KEY = new StringProperty("nameKey");
    static final StatusProperty<OrganizationStatus> STATUS = new StatusProperty<OrganizationStatus>(OrganizationStatus.class);
    static final ResourceReference<Tenant> TENANT = new ResourceReference<Tenant>("tenant", Tenant.class);
    static final ResourceReference<OrganizationAccountStoreMapping> DEFAULT_ACCOUNT_STORE_MAPPING = new ResourceReference<OrganizationAccountStoreMapping>("defaultAccountStoreMapping", OrganizationAccountStoreMapping.class);
    static final ResourceReference<OrganizationAccountStoreMapping> DEFAULT_GROUP_STORE_MAPPING = new ResourceReference<OrganizationAccountStoreMapping>("defaultGroupStoreMapping", OrganizationAccountStoreMapping.class);
    static final CollectionReference<OrganizationAccountStoreMappingList, OrganizationAccountStoreMapping> ACCOUNT_STORE_MAPPINGS = new CollectionReference<OrganizationAccountStoreMappingList, OrganizationAccountStoreMapping>("accountStoreMappings", OrganizationAccountStoreMappingList.class, OrganizationAccountStoreMapping.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultOrganization.createPropertyDescriptorMap(NAME, DESCRIPTION, NAME_KEY, STATUS, TENANT, CUSTOM_DATA, DEFAULT_ACCOUNT_STORE_MAPPING, DEFAULT_GROUP_STORE_MAPPING, ACCOUNT_STORE_MAPPINGS);

    public DefaultOrganization(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultOrganization(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public String getName() {
        return this.getString(NAME);
    }

    public Organization setName(String name) {
        this.setProperty(NAME, (Object)name);
        return this;
    }

    public String getNameKey() {
        return this.getString(NAME_KEY);
    }

    public Organization setNameKey(String nameKey) {
        this.setProperty(NAME_KEY, (Object)nameKey);
        return this;
    }

    public OrganizationStatus getStatus() {
        String value = this.getStringProperty(STATUS.getName());
        if (value == null) {
            return null;
        }
        return OrganizationStatus.valueOf((String)value.toUpperCase());
    }

    public Organization setStatus(OrganizationStatus status) {
        this.setProperty(STATUS, (Object)status.name());
        return this;
    }

    public String getDescription() {
        return this.getString(DESCRIPTION);
    }

    public Organization setDescription(String description) {
        this.setProperty(DESCRIPTION, (Object)description);
        return this;
    }

    public void delete() {
        this.getDataStore().delete(this);
    }

    public OrganizationAccountStoreMappingList getAccountStoreMappings() {
        return (OrganizationAccountStoreMappingList)this.getResourceProperty(ACCOUNT_STORE_MAPPINGS);
    }

    public OrganizationAccountStoreMappingList getAccountStoreMappings(Map<String, Object> queryParams) {
        OrganizationAccountStoreMappingList accountStoreMappings = this.getAccountStoreMappings();
        return this.getDataStore().getResource(accountStoreMappings.getHref(), OrganizationAccountStoreMappingList.class, queryParams);
    }

    public AccountStore getDefaultAccountStore() {
        OrganizationAccountStoreMapping accountStoreMap = this.getResourceProperty(DEFAULT_ACCOUNT_STORE_MAPPING);
        return accountStoreMap == null ? null : accountStoreMap.getAccountStore();
    }

    public OrganizationAccountStoreMappingList getAccountStoreMappings(OrganizationAccountStoreMappingCriteria criteria) {
        OrganizationAccountStoreMappingList mappings = this.getAccountStoreMappings();
        return this.getDataStore().getResource(mappings.getHref(), OrganizationAccountStoreMappingList.class, (Criteria)criteria);
    }

    public AccountStore getDefaultGroupStore() {
        OrganizationAccountStoreMapping accountStoreMap = this.getResourceProperty(DEFAULT_GROUP_STORE_MAPPING);
        return accountStoreMap == null ? null : accountStoreMap.getAccountStore();
    }

    public void setDefaultGroupStore(AccountStore accountStore) {
        OrganizationAccountStoreMappingList accountStoreMappingList = this.getAccountStoreMappings();
        boolean needToCreateNewStore = true;
        for (OrganizationAccountStoreMapping accountStoreMapping : accountStoreMappingList) {
            if (!accountStoreMapping.getAccountStore().getHref().equals(accountStore.getHref())) continue;
            needToCreateNewStore = false;
            accountStoreMapping.setDefaultGroupStore(true);
            accountStoreMapping.save();
            this.setProperty(DEFAULT_GROUP_STORE_MAPPING, (Object)accountStoreMapping);
            break;
        }
        if (needToCreateNewStore) {
            OrganizationAccountStoreMapping mapping = this.addAccountStore(accountStore);
            mapping.setDefaultGroupStore(true);
            mapping.save();
            this.setProperty(DEFAULT_GROUP_STORE_MAPPING, (Object)mapping);
        }
    }

    public void setDefaultAccountStore(AccountStore accountStore) {
        OrganizationAccountStoreMappingList accountStoreMappingList = this.getAccountStoreMappings();
        boolean needToCreateNewStore = true;
        for (OrganizationAccountStoreMapping accountStoreMapping : accountStoreMappingList) {
            if (!accountStoreMapping.getAccountStore().getHref().equals(accountStore.getHref())) continue;
            needToCreateNewStore = false;
            accountStoreMapping.setDefaultAccountStore(true);
            accountStoreMapping.save();
            this.setProperty(DEFAULT_ACCOUNT_STORE_MAPPING, (Object)accountStoreMapping);
            break;
        }
        if (needToCreateNewStore) {
            OrganizationAccountStoreMapping mapping = this.addAccountStore(accountStore);
            mapping.setDefaultAccountStore(true);
            mapping.save();
            this.setProperty(DEFAULT_ACCOUNT_STORE_MAPPING, (Object)mapping);
        }
    }

    public OrganizationAccountStoreMapping createAccountStoreMapping(OrganizationAccountStoreMapping mapping) throws ResourceException {
        return this.getDataStore().create("/organizationAccountStoreMappings", mapping);
    }

    public OrganizationAccountStoreMapping addAccountStore(AccountStore accountStore) throws ResourceException {
        Assert.notNull((Object)accountStore, (String)"accountStore cannot be null.");
        OrganizationAccountStoreMapping accountStoreMapping = (OrganizationAccountStoreMapping)this.getDataStore().instantiate(OrganizationAccountStoreMapping.class);
        accountStoreMapping.setAccountStore(accountStore);
        accountStoreMapping.setOrganization((Organization)this);
        accountStoreMapping.setListIndex(Integer.MAX_VALUE);
        accountStoreMapping = this.createAccountStoreMapping(accountStoreMapping);
        return accountStoreMapping;
    }

    public Account createAccount(Account account) {
        Assert.notNull((Object)account, (String)"Account instance cannot be null.");
        CreateAccountRequest request = Accounts.newCreateRequestFor((Account)account).build();
        return this.createAccount(request);
    }

    public Account createAccount(CreateAccountRequest request) {
        Assert.notNull((Object)request, (String)"Request cannot be null.");
        Account account = request.getAccount();
        Account createdAccount = null;
        AccountStore acctStore = this.getDefaultAccountStore();
        AccountStore accountStore = null;
        if (acctStore != null && acctStore.getHref().contains("directories")) {
            accountStore = (AccountStore)this.getDataStore().getResource(acctStore.getHref(), Directory.class);
        } else if (acctStore != null && acctStore.getHref().contains("groups")) {
            accountStore = (AccountStore)this.getDataStore().getResource(acctStore.getHref(), Group.class);
        }
        if (accountStore == null) {
            throw new IllegalStateException("No account store assigned to this organization has been configured as the default storage location for newly created accounts.");
        }
        if (accountStore instanceof Directory) {
            createdAccount = ((Directory)accountStore).createAccount(account);
        }
        if (accountStore instanceof Group) {
            createdAccount = ((Group)accountStore).getDirectory().createAccount(account);
        }
        return createdAccount;
    }

    public Group createGroup(Group group) {
        Assert.notNull((Object)group, (String)"Group instance cannot be null.");
        CreateGroupRequest request = Groups.newCreateRequestFor((Group)group).build();
        return this.createGroup(request);
    }

    public Group createGroup(CreateGroupRequest request) {
        Assert.notNull((Object)request, (String)"Request cannot be null.");
        Group group = request.getGroup();
        Group createdGroup = null;
        AccountStore groupStore = null;
        AccountStore store = this.getDefaultGroupStore();
        if (store != null && store.getHref().contains("directories")) {
            groupStore = (AccountStore)this.getDataStore().getResource(store.getHref(), Directory.class);
        }
        if (groupStore == null) {
            throw new IllegalStateException("No groupStore assigned to this organization has been configured as the default storage location for newly created accounts.");
        }
        createdGroup = ((Directory)groupStore).createGroup(group);
        return createdGroup;
    }

    public Tenant getTenant() {
        return this.getResourceProperty(TENANT);
    }

    public void accept(AccountStoreVisitor visitor) {
        visitor.visit((Organization)this);
    }

    public OrganizationAccountStoreMapping addAccountStore(String hrefOrName) {
        Assert.hasText((String)hrefOrName, (String)"hrefOrName cannot be null or empty.");
        AccountStore accountStore = null;
        String[] splitHrefOrName = hrefOrName.split("/");
        if (splitHrefOrName.length > 4) {
            Class<Directory> accountStoreType = null;
            String[] splitApplicationHref = this.getHref().split("/");
            if (splitHrefOrName.length == splitApplicationHref.length) {
                if (splitHrefOrName[4].equals("directories")) {
                    accountStoreType = Directory.class;
                } else if (splitHrefOrName[4].equals("groups")) {
                    accountStoreType = Group.class;
                }
            }
            if (accountStoreType != null) {
                try {
                    accountStore = (AccountStore)this.getDataStore().getResource(hrefOrName, accountStoreType);
                }
                catch (ResourceException resourceException) {
                    // empty catch block
                }
            }
        }
        if (accountStore == null) {
            Directory directory = this.getSingleTenantDirectory(Directories.where((Criterion)Directories.name().eqIgnoreCase(hrefOrName)));
            Group group = this.getSingleTenantGroup(Groups.where((Criterion)Groups.name().eqIgnoreCase(hrefOrName)));
            if (directory != null && group != null) {
                throw new IllegalArgumentException("There are both a Directory and a Group matching the provided name in the current tenant. Please provide the href of the intended Resource instead of its name in order to univocally identify it.");
            }
            Object object = accountStore = directory != null ? directory : group;
        }
        if (accountStore != null) {
            return this.addAccountStore(accountStore);
        }
        return null;
    }

    private Directory getSingleTenantDirectory(DirectoryCriteria criteria) {
        Assert.notNull((Object)criteria, (String)"criteria cannot be null.");
        Tenant tenant = (Tenant)this.getDataStore().getResource("/tenants/current", Tenant.class);
        DirectoryList directories = tenant.getDirectories(criteria);
        Directory foundDirectory = null;
        for (Directory dir : directories) {
            if (foundDirectory != null) {
                throw new IllegalArgumentException("The provided criteria matched more than one Directory in the current Tenant.");
            }
            foundDirectory = dir;
        }
        return foundDirectory;
    }

    private Group getSingleTenantGroup(GroupCriteria criteria) {
        Assert.notNull((Object)criteria, (String)"criteria cannot be null.");
        Tenant tenant = (Tenant)this.getDataStore().getResource("/tenants/current", Tenant.class);
        DirectoryList directories = tenant.getDirectories();
        Group foundGroup = null;
        for (Directory directory : directories) {
            GroupList groups = directory.getGroups(criteria);
            for (Group grp : groups) {
                if (foundGroup != null) {
                    throw new IllegalArgumentException("The provided criteria matched more than one Group in the current Tenant.");
                }
                foundGroup = grp;
            }
        }
        return foundGroup;
    }
}

