/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.oauth;

import com.stormpath.sdk.directory.AccountStore;
import com.stormpath.sdk.impl.oauth.DefaultOAuthPasswordGrantRequestAuthentication;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.oauth.OAuthPasswordGrantRequestAuthentication;
import com.stormpath.sdk.oauth.OAuthPasswordGrantRequestAuthenticationBuilder;

public class DefaultOAuthPasswordGrantRequestAuthenticationBuilder
implements OAuthPasswordGrantRequestAuthenticationBuilder {
    private String login;
    private String password;
    private AccountStore accountStore;

    public OAuthPasswordGrantRequestAuthenticationBuilder setLogin(String login) {
        Assert.hasText((String)login, (String)"username cannot be null or empty.");
        this.login = login;
        return this;
    }

    public OAuthPasswordGrantRequestAuthenticationBuilder setPassword(String password) {
        Assert.notNull((Object)password, (String)"password cannot be null or empty.");
        this.password = password;
        return this;
    }

    public OAuthPasswordGrantRequestAuthenticationBuilder setAccountStore(AccountStore accountStore) {
        Assert.notNull((Object)accountStore, (String)"accountStore cannot be null or empty.");
        this.accountStore = accountStore;
        return this;
    }

    public OAuthPasswordGrantRequestAuthentication build() {
        Assert.state((this.login != null ? 1 : 0) != 0, (String)"login has not been set. It is a required attribute.");
        Assert.state((this.password != null ? 1 : 0) != 0, (String)"password has not been set. It is a required attribute.");
        DefaultOAuthPasswordGrantRequestAuthentication request = new DefaultOAuthPasswordGrantRequestAuthentication(this.login, this.password);
        if (this.accountStore != null) {
            request.setAccountStore(this.accountStore);
        }
        return request;
    }
}

