/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.oauth;

import com.stormpath.sdk.impl.oauth.DefaultOAuthGrantRequestAuthenticationResult;
import com.stormpath.sdk.impl.oauth.OAuthGrantRequestAuthenticationResultBuilder;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.oauth.AccessToken;
import com.stormpath.sdk.oauth.GrantAuthenticationToken;
import com.stormpath.sdk.oauth.RefreshToken;

public class DefaultOAuthGrantRequestAuthenticationResultBuilder
implements OAuthGrantRequestAuthenticationResultBuilder {
    protected AccessToken accessToken;
    protected String accessTokenString;
    protected RefreshToken refreshToken;
    protected String refreshTokenString;
    protected String accessTokenHref;
    protected String tokenType;
    protected long expiresIn;
    protected Boolean isRefreshGrantAuthRequest = false;
    protected GrantAuthenticationToken grantAuthenticationToken;

    public DefaultOAuthGrantRequestAuthenticationResultBuilder(GrantAuthenticationToken grantAuthenticationToken) {
        Assert.notNull((Object)grantAuthenticationToken, (String)"grantAuthenticationToken cannot be null.");
        this.grantAuthenticationToken = grantAuthenticationToken;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public String getAccessTokenString() {
        return this.accessTokenString;
    }

    public RefreshToken getRefreshToken() {
        return this.refreshToken;
    }

    public String getRefreshTokenString() {
        return this.refreshTokenString;
    }

    public String getAccessTokenHref() {
        return this.accessTokenHref;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public long getExpiresIn() {
        return this.expiresIn;
    }

    @Override
    public OAuthGrantRequestAuthenticationResultBuilder setIsRefreshAuthGrantRequest(Boolean isRefreshAuthGrantRequest) {
        this.isRefreshGrantAuthRequest = isRefreshAuthGrantRequest;
        return this;
    }

    @Override
    public DefaultOAuthGrantRequestAuthenticationResult build() {
        Assert.notNull((Object)this.grantAuthenticationToken, (String)"grantAuthenticationToken has not been set. It is a required attribute.");
        this.accessToken = this.grantAuthenticationToken.getAsAccessToken();
        this.accessTokenString = this.grantAuthenticationToken.getAccessToken();
        this.refreshTokenString = this.grantAuthenticationToken.getRefreshToken();
        this.accessTokenHref = this.grantAuthenticationToken.getAccessTokenHref();
        this.tokenType = this.grantAuthenticationToken.getTokenType();
        this.expiresIn = Integer.parseInt(this.grantAuthenticationToken.getExpiresIn());
        if (this.isRefreshGrantAuthRequest.booleanValue()) {
            this.refreshToken = this.grantAuthenticationToken.getAsRefreshToken();
        }
        return new DefaultOAuthGrantRequestAuthenticationResult(this);
    }
}

