/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.oauth;

import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.ds.DataStore;
import com.stormpath.sdk.impl.http.HttpHeaders;
import com.stormpath.sdk.impl.http.MediaType;
import com.stormpath.sdk.impl.oauth.AbstractOAuthRequestAuthenticator;
import com.stormpath.sdk.impl.oauth.DefaultOAuthClientCredentialsGrantAuthenticationAttempt;
import com.stormpath.sdk.impl.oauth.DefaultOAuthClientCredentialsGrantRequestAuthenticationResultBuilder;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.oauth.GrantAuthenticationToken;
import com.stormpath.sdk.oauth.OAuthClientCredentialsGrantRequestAuthentication;
import com.stormpath.sdk.oauth.OAuthClientCredentialsGrantRequestAuthenticator;
import com.stormpath.sdk.oauth.OAuthGrantRequestAuthenticationResult;
import com.stormpath.sdk.oauth.OAuthRequestAuthentication;

public class DefaultOAuthClientCredentialsGrantRequestAuthenticator
extends AbstractOAuthRequestAuthenticator
implements OAuthClientCredentialsGrantRequestAuthenticator {
    private static final String OAUTH_TOKEN_PATH = "/oauth/token";

    public DefaultOAuthClientCredentialsGrantRequestAuthenticator(Application application, DataStore dataStore) {
        super(application, dataStore);
    }

    public OAuthGrantRequestAuthenticationResult authenticate(OAuthRequestAuthentication authenticationRequest) {
        Assert.notNull((Object)this.application, (String)"application cannot be null or empty");
        Assert.isInstanceOf(OAuthClientCredentialsGrantRequestAuthentication.class, (Object)authenticationRequest, (String)"authenticationRequest must be an instance of OAuthClientCredentialsGrantRequestAuthentication.");
        OAuthClientCredentialsGrantRequestAuthentication oAuthClientCredentialsGrantRequestAuthentication = (OAuthClientCredentialsGrantRequestAuthentication)authenticationRequest;
        DefaultOAuthClientCredentialsGrantAuthenticationAttempt oAuthClientCredentialsGrantAuthenticationAttempt = new DefaultOAuthClientCredentialsGrantAuthenticationAttempt(this.dataStore);
        oAuthClientCredentialsGrantAuthenticationAttempt.setGrantType(oAuthClientCredentialsGrantRequestAuthentication.getGrantType());
        oAuthClientCredentialsGrantAuthenticationAttempt.setApiKeyId(oAuthClientCredentialsGrantRequestAuthentication.getApiKeyId());
        oAuthClientCredentialsGrantAuthenticationAttempt.setApiKeySecret(oAuthClientCredentialsGrantRequestAuthentication.getApiKeySecret());
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        GrantAuthenticationToken grantResult = this.dataStore.create(this.application.getHref() + OAUTH_TOKEN_PATH, oAuthClientCredentialsGrantAuthenticationAttempt, GrantAuthenticationToken.class, httpHeaders);
        DefaultOAuthClientCredentialsGrantRequestAuthenticationResultBuilder builder = new DefaultOAuthClientCredentialsGrantRequestAuthenticationResultBuilder(grantResult);
        return builder.build();
    }
}

