/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.mail;

import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.resource.AbstractInstanceResource;
import com.stormpath.sdk.impl.resource.StringProperty;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.mail.EmailTemplate;
import com.stormpath.sdk.mail.MimeType;
import java.util.Map;

public abstract class AbstractEmailTemplate<T extends EmailTemplate>
extends AbstractInstanceResource
implements EmailTemplate<T> {
    static final StringProperty NAME = new StringProperty("name");
    static final StringProperty DESCRIPTION = new StringProperty("description");
    static final StringProperty FROM_NAME = new StringProperty("fromName");
    static final StringProperty FROM_EMAIL_ADDRESS = new StringProperty("fromEmailAddress");
    static final StringProperty SUBJECT = new StringProperty("subject");
    static final StringProperty TEXT_BODY = new StringProperty("textBody");
    static final StringProperty HTML_BODY = new StringProperty("htmlBody");
    static final StringProperty MIME_TYPE = new StringProperty("mimeType");

    protected AbstractEmailTemplate(InternalDataStore dataStore) {
        super(dataStore);
    }

    protected AbstractEmailTemplate(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    public String getName() {
        return this.getString(NAME);
    }

    public T setName(String name) {
        Assert.hasText((String)name, (String)"name cannot be null or empty.");
        this.setProperty(NAME, (Object)name);
        return (T)this;
    }

    public String getDescription() {
        return this.getString(DESCRIPTION);
    }

    public T setDescription(String description) {
        this.setProperty(DESCRIPTION, (Object)description);
        return (T)this;
    }

    public String getFromName() {
        return this.getString(FROM_NAME);
    }

    public T setFromName(String fromName) {
        Assert.hasText((String)fromName, (String)"fromName cannot be null or empty.");
        this.setProperty(FROM_NAME, (Object)fromName);
        return (T)this;
    }

    public String getFromEmailAddress() {
        return this.getString(FROM_EMAIL_ADDRESS);
    }

    public T setFromEmailAddress(String fromEmailAddress) {
        Assert.hasText((String)fromEmailAddress, (String)"fromEmailAddress cannot be null or empty.");
        this.setProperty(FROM_EMAIL_ADDRESS, (Object)fromEmailAddress);
        return (T)this;
    }

    public String getSubject() {
        return this.getString(SUBJECT);
    }

    public T setSubject(String subject) {
        Assert.hasText((String)subject, (String)"subject cannot be null or empty.");
        this.setProperty(SUBJECT, (Object)subject);
        return (T)this;
    }

    public String getTextBody() {
        return this.getString(TEXT_BODY);
    }

    public T setTextBody(String textBody) {
        Assert.notNull((Object)textBody, (String)"textBody cannot be null or empty.");
        this.setProperty(TEXT_BODY, (Object)textBody);
        return (T)this;
    }

    public String getHtmlBody() {
        return this.getString(HTML_BODY);
    }

    public T setHtmlBody(String htmlBody) {
        Assert.notNull((Object)htmlBody, (String)"htmlBody cannot be null or empty.");
        this.setProperty(HTML_BODY, (Object)htmlBody);
        return (T)this;
    }

    public MimeType getMimeType() {
        String value = this.getStringProperty(MIME_TYPE.getName());
        if (value == null) {
            return null;
        }
        return MimeType.fromString((String)value.toUpperCase());
    }

    public T setMimeType(MimeType mimeType) {
        Assert.notNull((Object)mimeType, (String)"mimeType cannot be null");
        this.setProperty(MIME_TYPE, (Object)mimeType.value());
        return (T)this;
    }
}

