/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.jwt;

import com.stormpath.sdk.error.jwt.InvalidJwtException;
import com.stormpath.sdk.impl.ds.JacksonMapMarshaller;
import com.stormpath.sdk.impl.ds.MapMarshaller;
import com.stormpath.sdk.impl.util.Base64;
import com.stormpath.sdk.lang.Strings;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.StringTokenizer;

public class JwtWrapper {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String SEPARATOR = ".";
    private final String base64JwtHeader;
    private final String base64JsonPayload;
    private final String base64JwtSignature;
    private final MapMarshaller mapMarshaller;

    public JwtWrapper(String jwt) {
        if (!Strings.hasText((String)jwt)) {
            throw new InvalidJwtException("JWT parameter is required..");
        }
        StringTokenizer tokenizer = new StringTokenizer(jwt, SEPARATOR);
        if (tokenizer.countTokens() != 3) {
            throw new InvalidJwtException("The jwt value format is not correct.");
        }
        this.base64JwtHeader = tokenizer.nextToken();
        this.base64JsonPayload = tokenizer.nextToken();
        this.base64JwtSignature = tokenizer.nextToken();
        this.mapMarshaller = new JacksonMapMarshaller();
    }

    public String getBase64JwtHeader() {
        return this.base64JwtHeader;
    }

    public String getBase64JsonPayload() {
        return this.base64JsonPayload;
    }

    public String getBase64JwtSignature() {
        return this.base64JwtSignature;
    }

    public Map getJsonHeaderAsMap() {
        byte[] jsonBytes = Base64.decodeBase64(this.base64JwtHeader);
        if (jsonBytes == null) {
            throw new InvalidJwtException("JWT json header cannot be decoded.");
        }
        return this.mapMarshaller.unmarshal(new String(jsonBytes, UTF_8));
    }

    public Map getJsonPayloadAsMap() {
        byte[] jsonBytes = Base64.decodeBase64(this.base64JsonPayload);
        if (jsonBytes == null) {
            throw new InvalidJwtException("JWT json body cannot be decoded.");
        }
        return this.mapMarshaller.unmarshal(new String(jsonBytes, UTF_8));
    }
}

