/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.http.support;

import com.stormpath.sdk.impl.http.support.Version;
import com.stormpath.sdk.lang.Classes;
import com.stormpath.sdk.lang.Strings;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class UserAgent {
    private static final String INTEGRATION_SHIRO_ID = "stormpath-shiro";
    private static final String INTEGRATION_SHIRO_CLASS = "com.stormpath.shiro.realm.ApplicationRealm";
    private static final String INTEGRATION_SPRING_SECURITY_ID = "stormpath-spring-security";
    private static final String INTEGRATION_SPRING_SECURITY_CLASS = "com.stormpath.spring.security.provider.StormpathAuthenticationProvider";
    private static final String STORMPATH_SDK_STRING = "stormpath-sdk-java";
    private static final String STORMPATH_SDK_SERVLET_ID = "stormpath-servlet-java";
    private static final String STORMPATH_SDK_SERVLET_CLASS = "com.stormpath.sdk.servlet.config.Config";
    private static final String STORMPATH_SDK_RUNTIME_SPRING_WEBMVC_ID = "stormpath-spring-webmvc";
    private static final String STORMPATH_SDK_RUNTIME_SPRING_WEBMVC_CLASS = "com.stormpath.spring.mvc.AbstractSpringControllerConfig";
    private static final String STORMPATH_SDK_SPRING_BOOT_STARTER_ID = "stormpath-spring-boot-starter";
    private static final String STORMPATH_SDK_SPRING_BOOT_STARTER_CLASS = "com.stormpath.spring.boot.autoconfigure.StormpathAutoConfiguration";
    private static final String INTEGRATION_RUNTIME_SPRING_ID = "spring";
    private static final String INTEGRATION_RUNTIME_SPRING_CLASS = "org.springframework.context.ApplicationContext";
    private static final String RAPID_PROTOTYPING_SPRING_BOOT_ID = "spring-boot";
    private static final String RAPID_PROTOTYPING_SPRING_BOOT_CLASS = "org.springframework.boot.SpringApplication";
    private static final String JAVA_SDK_RUNTIME_STRING = "java";
    private static final String SECURITY_FRAMEWORK_SHIRO_ID = "shiro";
    private static final String SECURITY_FRAMEWORK_SHIRO_CLASS = "org.apache.shiro.SecurityUtils";
    private static final String SECURITY_FRAMEWORK_SPRING_SECURITY_ID = "spring-security";
    private static final String SECURITY_FRAMEWORK_SPRING_SECURITY_CLASS = "org.springframework.security.core.SpringSecurityCoreVersion";
    private static final String WEB_SERVER_TOMCAT_ID = "tomcat";
    private static final String WEB_SERVER_TOMCAT_BOOTSTRAP_CLASS = "org.apache.catalina.startup.Bootstrap";
    private static final String WEB_SERVER_TOMCAT_EMBEDDED_CLASS = "org.apache.catalina.startup.Tomcat";
    private static final String WEB_SERVER_JETTY_ID = "jetty";
    private static final String WEB_SERVER_JETTY_CLASS = "org.eclipse.jetty.servlet.listener.ELContextCleaner";
    private static final String WEB_SERVER_JBOSS_ID = "jboss";
    private static final String WEB_SERVER_JBOSS_CLASS = "org.jboss.as.security.plugins.AuthenticationCacheEvictionListener";
    private static final String WEB_SERVER_WEBSPHERE_ID = "websphere";
    private static final String WEB_SERVER_WEBSPHERE_CLASS = "com.ibm.websphere.product.VersionInfo";
    private static final String WEB_SERVER_GLASSFISH_ID = "glassfish";
    private static final String WEB_SERVER_GLASSFISH_CLASS = "com.sun.enterprise.glassfish.bootstrap.GlassFishMain";
    private static final String WEB_SERVER_WEBLOGIC_ID = "weblogic";
    private static final String WEB_SERVER_WEBLOGIC_CLASS = "weblogic.version";
    private static final String WEB_SERVER_WILDFLY_ID = "wildfly";
    private static final String WEB_SERVER_WILDFLY_CLASS = "org.jboss.as.security.ModuleName";
    private static final String VERSION_SEPARATOR = "/";
    private static final String ENTRY_SEPARATOR = " ";
    private static final String USER_AGENT = UserAgent.createUserAgentString();

    private UserAgent() {
    }

    public static String getUserAgentString() {
        return USER_AGENT;
    }

    private static String createUserAgentString() {
        String userAgent = UserAgent.getIntegrationString() + UserAgent.getStormpathSDKComponentsString() + UserAgent.getStormpathSdkString() + UserAgent.getSecurityFrameworkString() + UserAgent.getIntegrationRuntimeString() + UserAgent.getSpringBootString() + UserAgent.getWebServerString() + UserAgent.getJavaSDKRuntimeString() + UserAgent.getOSString();
        return userAgent.trim();
    }

    private static String getIntegrationString() {
        String integrationString = UserAgent.getFullEntryStringUsingPomProperties(INTEGRATION_SHIRO_CLASS, INTEGRATION_SHIRO_ID);
        if (Strings.hasText((String)integrationString)) {
            return integrationString;
        }
        integrationString = UserAgent.getFullEntryStringUsingPomProperties(INTEGRATION_SPRING_SECURITY_CLASS, INTEGRATION_SPRING_SECURITY_ID);
        if (Strings.hasText((String)integrationString)) {
            return integrationString;
        }
        return "";
    }

    private static String getStormpathSdkString() {
        return "stormpath-sdk-java/" + Version.getClientVersion() + ENTRY_SEPARATOR;
    }

    private static String getIntegrationRuntimeString() {
        String integrationRuntimeString = UserAgent.getFullEntryStringUsingManifest(INTEGRATION_RUNTIME_SPRING_CLASS, INTEGRATION_RUNTIME_SPRING_ID);
        if (Strings.hasText((String)integrationRuntimeString)) {
            return integrationRuntimeString;
        }
        return "";
    }

    private static String getJavaSDKRuntimeString() {
        return "java/" + System.getProperty("java.version") + ENTRY_SEPARATOR;
    }

    private static String getOSString() {
        return System.getProperty("os.name") + VERSION_SEPARATOR + System.getProperty("os.version") + ENTRY_SEPARATOR;
    }

    private static String getSpringBootString() {
        String springBootStarter = UserAgent.getFullEntryStringUsingManifest(RAPID_PROTOTYPING_SPRING_BOOT_CLASS, RAPID_PROTOTYPING_SPRING_BOOT_ID);
        if (Strings.hasText((String)springBootStarter)) {
            return springBootStarter;
        }
        return "";
    }

    private static String getSecurityFrameworkString() {
        String securityFrameworkString = UserAgent.getFullEntryStringUsingManifest(SECURITY_FRAMEWORK_SHIRO_CLASS, SECURITY_FRAMEWORK_SHIRO_ID);
        if (Strings.hasText((String)securityFrameworkString)) {
            return securityFrameworkString;
        }
        securityFrameworkString = UserAgent.getFullEntryStringUsingManifest(SECURITY_FRAMEWORK_SPRING_SECURITY_CLASS, SECURITY_FRAMEWORK_SPRING_SECURITY_ID);
        if (Strings.hasText((String)securityFrameworkString)) {
            return securityFrameworkString;
        }
        return "";
    }

    private static String getStormpathSDKComponentsString() {
        String stormpathSpringBootStarterString;
        String stormpathSpringWebMvcString;
        StringBuffer stormpathComponentsString = new StringBuffer();
        String sdkServletString = UserAgent.getFullEntryStringUsingSDKVersion(STORMPATH_SDK_SERVLET_CLASS, STORMPATH_SDK_SERVLET_ID);
        if (Strings.hasText((String)sdkServletString)) {
            stormpathComponentsString.append(sdkServletString);
        }
        if (Strings.hasText((String)(stormpathSpringWebMvcString = UserAgent.getFullEntryStringUsingSDKVersion(STORMPATH_SDK_RUNTIME_SPRING_WEBMVC_CLASS, STORMPATH_SDK_RUNTIME_SPRING_WEBMVC_ID)))) {
            stormpathComponentsString.append(stormpathSpringWebMvcString);
        }
        if (Strings.hasText((String)(stormpathSpringBootStarterString = UserAgent.getFullEntryStringUsingSDKVersion(STORMPATH_SDK_SPRING_BOOT_STARTER_CLASS, STORMPATH_SDK_SPRING_BOOT_STARTER_ID)))) {
            stormpathComponentsString.append(stormpathSpringBootStarterString);
        }
        return stormpathComponentsString.toString();
    }

    private static String getWebServerString() {
        String webServerString = UserAgent.getFullEntryStringUsingManifest(WEB_SERVER_GLASSFISH_CLASS, WEB_SERVER_GLASSFISH_ID);
        if (Strings.hasText((String)webServerString)) {
            return webServerString;
        }
        webServerString = UserAgent.getFullEntryStringUsingManifest(WEB_SERVER_TOMCAT_BOOTSTRAP_CLASS, WEB_SERVER_TOMCAT_ID);
        if (Strings.hasText((String)webServerString)) {
            return webServerString;
        }
        webServerString = UserAgent.getFullEntryStringUsingManifest(WEB_SERVER_TOMCAT_EMBEDDED_CLASS, WEB_SERVER_TOMCAT_ID);
        if (Strings.hasText((String)webServerString)) {
            return webServerString;
        }
        webServerString = UserAgent.getFullEntryStringUsingManifest(WEB_SERVER_JETTY_CLASS, WEB_SERVER_JETTY_ID);
        if (Strings.hasText((String)webServerString)) {
            return webServerString;
        }
        webServerString = UserAgent.getWildFlyEntryString();
        if (Strings.hasText((String)webServerString)) {
            return webServerString;
        }
        webServerString = UserAgent.getFullEntryStringUsingManifest(WEB_SERVER_JBOSS_CLASS, WEB_SERVER_JBOSS_ID);
        if (Strings.hasText((String)webServerString)) {
            return webServerString;
        }
        webServerString = UserAgent.getWebSphereEntryString();
        if (Strings.hasText((String)webServerString)) {
            return webServerString;
        }
        webServerString = UserAgent.getWebLogicEntryString();
        if (Strings.hasText((String)webServerString)) {
            return webServerString;
        }
        return "";
    }

    private static String getFullEntryStringUsingPomProperties(String fqcn, String entryId) {
        if (Classes.isAvailable((String)fqcn)) {
            return entryId + VERSION_SEPARATOR + UserAgent.getVersionInfoFromPomProperties(fqcn) + ENTRY_SEPARATOR;
        }
        return null;
    }

    private static String getFullEntryStringUsingManifest(String fqcn, String entryId) {
        if (Classes.isAvailable((String)fqcn)) {
            return entryId + VERSION_SEPARATOR + UserAgent.getVersionInfoInManifest(fqcn) + ENTRY_SEPARATOR;
        }
        return null;
    }

    private static String getFullEntryStringUsingSDKVersion(String fqcn, String entryId) {
        if (Classes.isAvailable((String)fqcn)) {
            return entryId + VERSION_SEPARATOR + Version.getClientVersion() + ENTRY_SEPARATOR;
        }
        return null;
    }

    private static String getWebSphereEntryString() {
        if (Classes.isAvailable((String)WEB_SERVER_WEBSPHERE_CLASS)) {
            return "websphere/" + UserAgent.getWebSphereVersion() + ENTRY_SEPARATOR;
        }
        return null;
    }

    private static String getWebLogicEntryString() {
        if (Classes.isAvailable((String)WEB_SERVER_WEBLOGIC_CLASS)) {
            return "weblogic/" + UserAgent.getWebLogicVersion() + ENTRY_SEPARATOR;
        }
        return null;
    }

    private static String getWildFlyEntryString() {
        try {
            Package wildFlyPkg;
            if (Classes.isAvailable((String)WEB_SERVER_WILDFLY_CLASS) && (wildFlyPkg = Classes.forName((String)WEB_SERVER_WILDFLY_CLASS).getPackage()) != null && Strings.hasText((String)wildFlyPkg.getImplementationTitle()) && wildFlyPkg.getImplementationTitle().contains("WildFly")) {
                return "wildfly/" + wildFlyPkg.getImplementationVersion() + ENTRY_SEPARATOR;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String getVersionInfoFromPomProperties(String fqcn) {
        String version;
        block8: {
            version = "unknown";
            try {
                String line;
                Class clazz = Classes.forName((String)fqcn);
                String className = clazz.getSimpleName() + ".class";
                String classPath = clazz.getResource(className).toString();
                String jarPath = null;
                if (classPath.startsWith("jar:file:")) {
                    jarPath = classPath.subSequence(9, classPath.lastIndexOf("!")).toString();
                } else if (classPath.startsWith("vfs:")) {
                    jarPath = classPath.subSequence(4, classPath.lastIndexOf(".jar") + 4).toString();
                }
                if (jarPath == null) {
                    return version;
                }
                JarFile jarFile = new JarFile(jarPath);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                String pomPropertiesPath = null;
                while (enumeration.hasMoreElements()) {
                    JarEntry entry = enumeration.nextElement();
                    if (!entry.getName().endsWith("pom.properties")) continue;
                    pomPropertiesPath = entry.getName();
                    break;
                }
                if (pomPropertiesPath == null) break block8;
                BufferedReader reader = new BufferedReader(new InputStreamReader(clazz.getResourceAsStream(VERSION_SEPARATOR + pomPropertiesPath)));
                while ((line = reader.readLine()) != null) {
                    if (!line.startsWith("version=")) continue;
                    version = line.split("=")[1];
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return version;
    }

    private static String getVersionInfoInManifest(String fqcn) {
        Package thePackage = Classes.forName((String)fqcn).getPackage();
        String version = thePackage.getSpecificationVersion();
        if (!Strings.hasText((String)version)) {
            version = thePackage.getImplementationVersion();
        }
        if (!Strings.hasText((String)version)) {
            version = "null";
        }
        return version;
    }

    private static String getWebSphereVersion() {
        try {
            Class<?> versionClass = Class.forName(WEB_SERVER_WEBSPHERE_CLASS);
            Object versionInfo = versionClass.newInstance();
            Method method = versionClass.getDeclaredMethod("runReport", String.class, PrintWriter.class);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            method.invoke(versionInfo, "", printWriter);
            String version = stringWriter.toString();
            version = version.substring(version.indexOf("Installed Product"));
            version = version.substring(version.indexOf("Version"));
            version = version.substring(version.indexOf(ENTRY_SEPARATOR), version.indexOf("\n")).trim();
            return version;
        }
        catch (Exception exception) {
            return "null";
        }
    }

    private static String getWebLogicVersion() {
        try {
            Class<?> versionClass = Class.forName(WEB_SERVER_WEBLOGIC_CLASS);
            Object version = versionClass.newInstance();
            Method method = versionClass.getDeclaredMethod("getReleaseBuildVersion", new Class[0]);
            return (String)method.invoke(version, new Object[0]);
        }
        catch (Exception exception) {
            return "null";
        }
    }
}

